/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.spawn;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.Location;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.util.TeleportUtils;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;

public class SpawnCommand
extends BaseCommand {
    public SpawnCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)this.builder.executes(context -> this.execute((CommandSource)context.getSource()));
    }

    private int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("spawn", ModConfig.spawn_cooldown.intValue());
        if (cooldown != 0L) {
            this.sendMessage(player, "maessentials.cooldown.teleport", cooldown);
            return 1;
        }
        eslPlayer.getUsage().setCommandUsage("spawn");
        eslPlayer.saveData();
        Location location = DataManager.getWorld().getSpawn();
        if (TeleportUtils.simpleTeleport(player, location, "spawn", ModConfig.spawn_delay.intValue())) {
            if (ModConfig.spawn_delay == 0) {
                this.sendMessage(player, "spawn.maessentials.success", new Object[0]);
            } else {
                this.sendMessage(player, "spawn.maessentials.success.wait", ModConfig.spawn_delay);
            }
        }
        return 1;
    }
}

