/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.teleport_request;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.util.TeleportUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class TpaCommand
extends BaseCommand {
    public TpaCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)this.builder.then(Commands.func_197056_a((String)"targetPlayer", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> this.execute((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"targetPlayer"))));
    }

    private int execute(CommandSource source, ServerPlayerEntity targetPlayer) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        if (player == targetPlayer) {
            this.sendMessage(player, "tpa.maessentials.self", new Object[0]);
            return 1;
        }
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("tpa", ModConfig.tpa_cooldown.intValue());
        if (cooldown != 0L) {
            this.sendMessage(player, "maessentials.cooldown.teleport", cooldown);
            return 1;
        }
        eslPlayer.getUsage().setCommandUsage("tpa");
        eslPlayer.saveData();
        if (TeleportUtils.requestTeleport(player, player, targetPlayer, ModConfig.tpa_timeout.intValue())) {
            this.sendMessage(player, "tpa.maessentials.request", targetPlayer.func_145748_c_());
            this.sendMessage(targetPlayer, "tpa.maessentials.request.target", player.func_145748_c_());
            ClickEvent clickEventAccept = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tpaccept " + player.func_145748_c_().getString());
            HoverEvent eventHoverAccept = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("tpa.maessentials.request.target.accept.hover", new Object[]{"/tpaccept " + player.func_145748_c_().getString()}));
            StringTextComponent textAccept = new StringTextComponent("/tpaccept");
            textAccept.func_150256_b().func_150241_a(clickEventAccept);
            textAccept.func_150256_b().func_150209_a(eventHoverAccept);
            this.sendMessage(targetPlayer, "tpa.maessentials.request.target.accept", textAccept);
            ClickEvent clickEventDeny = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tpdeny " + player.func_145748_c_().getString());
            HoverEvent eventHoverDeny = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("tpa.maessentials.request.target.deny.hover", new Object[]{"/tpdeny " + player.func_145748_c_().getString()}));
            StringTextComponent textDeny = new StringTextComponent("/tpdeny");
            textDeny.func_150256_b().func_150241_a(clickEventDeny);
            textDeny.func_150256_b().func_150209_a(eventHoverDeny);
            this.sendMessage(targetPlayer, "tpa.maessentials.request.target.deny", textDeny);
        }
        return 1;
    }
}

