/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.warp;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.Location;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.util.ModUtils;
import com.maciej916.maessentials.common.util.PlayerUtils;
import com.maciej916.maessentials.common.util.TeleportUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;

public class WarpCommand
extends BaseCommand {
    public WarpCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)this.builder.executes(context -> this.execute((CommandSource)context.getSource()))).then(Commands.func_197056_a((String)"warpName", (ArgumentType)StringArgumentType.string()).suggests(ModUtils.WARP_SUGGEST).executes(context -> this.execute((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"warpName"))));
    }

    private int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        PlayerUtils.warpList(player);
        return 1;
    }

    private int execute(CommandSource source, String warpName) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        Location location = DataManager.getWarp().getWarp(warpName);
        if (location == null) {
            this.sendMessage(player, "warp.maessentials.not_exist", warpName);
            return 1;
        }
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("warp", ModConfig.warps_cooldown.intValue());
        if (cooldown != 0L) {
            this.sendMessage(player, "maessentials.cooldown.teleport", cooldown);
            return 1;
        }
        eslPlayer.getUsage().setCommandUsage("warp");
        eslPlayer.saveData();
        if (TeleportUtils.simpleTeleport(player, location, "warp", ModConfig.warps_delay.intValue())) {
            if (ModConfig.warps_delay == 0) {
                this.sendMessage(player, "warp.maessentials.success", warpName);
            } else {
                this.sendMessage(player, "warp.maessentials.success.wait", warpName, ModConfig.warps_delay);
            }
        }
        return 1;
    }
}

