/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.lib.player;

import com.google.gson.annotations.JsonAdapter;
import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.lib.Storage;
import com.maciej916.maessentials.common.lib.home.HomeData;
import com.maciej916.maessentials.common.lib.player.EssentialPlayerSD;
import com.maciej916.maessentials.common.lib.player.PlayerData;
import com.maciej916.maessentials.common.lib.player.PlayerRestrictions;
import com.maciej916.maessentials.common.lib.player.PlayerTemp;
import com.maciej916.maessentials.common.lib.player.PlayerUsage;
import com.maciej916.maessentials.common.util.JsonUtils;
import java.util.UUID;

@JsonAdapter(value=EssentialPlayerSD.class)
public class EssentialPlayer {
    private UUID playerUUID;
    private String username;
    private HomeData home_data = new HomeData();
    private PlayerData data = new PlayerData();
    private PlayerUsage last_usage = new PlayerUsage();
    private PlayerRestrictions restrictions = new PlayerRestrictions();
    private PlayerTemp temp_data = new PlayerTemp();
    private Storage custom_data = new Storage();

    public void setHomeData(HomeData home_data) {
        this.home_data = home_data;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getUsername() {
        return this.username;
    }

    public PlayerData getData() {
        return this.data;
    }

    public PlayerUsage getUsage() {
        return this.last_usage;
    }

    public PlayerRestrictions getRestrictions() {
        return this.restrictions;
    }

    public PlayerTemp getTemp() {
        return this.temp_data;
    }

    public Storage getCustomData() {
        return this.custom_data;
    }

    public HomeData getHomeData() {
        return this.home_data;
    }

    public EssentialPlayer(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public EssentialPlayer(UUID playerUUID, String username, PlayerData data, PlayerRestrictions restrictions, PlayerUsage last_usage, Storage custom_data) {
        this.playerUUID = playerUUID;
        this.username = username;
        this.data = data;
        this.restrictions = restrictions;
        this.last_usage = last_usage;
        this.custom_data = custom_data;
    }

    public void cleanTemp() {
        this.temp_data = new PlayerTemp();
    }

    public void saveData() {
        JsonUtils.save(ModConfig.worldCatalog + "players/", this.playerUUID.toString(), this);
    }

    public void saveHomes() {
        JsonUtils.save(ModConfig.worldCatalog + "homes/", this.playerUUID.toString(), this.home_data);
    }
}

