/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.lib.player;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.maciej916.maessentials.common.lib.Storage;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.lib.player.PlayerData;
import com.maciej916.maessentials.common.lib.player.PlayerRestrictions;
import com.maciej916.maessentials.common.lib.player.PlayerUsage;
import com.maciej916.maessentials.common.util.JsonUtils;
import java.lang.reflect.Type;
import java.util.UUID;

public class EssentialPlayerSD
implements JsonDeserializer<EssentialPlayer>,
JsonSerializer<EssentialPlayer> {
    public EssentialPlayer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        UUID uuid = (UUID)new Gson().fromJson(object.get("uuid"), UUID.class);
        String username = (String)new Gson().fromJson(object.get("username"), String.class);
        PlayerData data = (PlayerData)new Gson().fromJson(object.get("data"), PlayerData.class);
        PlayerUsage last_usage = (PlayerUsage)new Gson().fromJson(object.get("last_usage"), PlayerUsage.class);
        PlayerRestrictions restrictions = (PlayerRestrictions)new Gson().fromJson(object.get("restrictions"), PlayerRestrictions.class);
        Storage custom_data = (Storage)new Gson().fromJson((JsonElement)JsonUtils.getJsonObject(object.get("custom_data")), Storage.class);
        EssentialPlayer eslPlayer = new EssentialPlayer(uuid, username, data, restrictions, last_usage, custom_data);
        return eslPlayer;
    }

    public JsonElement serialize(EssentialPlayer src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.add("uuid", JsonUtils.getJsonElement(src.getPlayerUUID().toString()));
        object.add("username", JsonUtils.getJsonElement(src.getUsername()));
        object.add("data", JsonUtils.getJsonElement(src.getData()));
        object.add("last_usage", JsonUtils.getJsonElement(src.getUsage()));
        object.add("restrictions", JsonUtils.getJsonElement(src.getRestrictions()));
        object.add("custom_data", JsonUtils.getJsonElement(src.getCustomData().getData()));
        return object;
    }
}

