/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.subscribe.events;

import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.Location;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.util.LocationUtils;
import com.maciej916.maessentials.common.util.ModUtils;
import com.maciej916.maessentials.common.util.TeleportUtils;
import com.maciej916.maessentials.common.util.TextUtils;
import com.maciej916.maessentials.common.util.TimeUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maessentials", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventWorldTick {
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (tickCounter == 20) {
                TeleportUtils.checkTeleports();
                if (event.world.func_73046_m() != null && event.world.func_73046_m().func_71262_S() && ModConfig.afk_auto.booleanValue() || ModUtils.isDev()) {
                    EventWorldTick.checkAfk(event.world.func_73046_m().func_184103_al());
                }
                tickCounter = 0;
            } else {
                ++tickCounter;
            }
        }
    }

    public static void checkAfk(PlayerList players) {
        try {
            if (players != null && players.func_181057_v().size() > 0) {
                for (int i = players.func_181057_v().size() - 1; i >= 0; --i) {
                    ServerPlayerEntity player = (ServerPlayerEntity)players.func_181057_v().get(i);
                    if (player == null) continue;
                    EssentialPlayer eslPlayer = DataManager.getPlayer(player);
                    Location playerLocation = new Location(player);
                    Location lastLocation = eslPlayer.getTemp().getLocation();
                    if (lastLocation != null && LocationUtils.checkDetailedLocation(playerLocation, lastLocation)) {
                        if (!eslPlayer.getTemp().isAfk()) {
                            if (TimeUtils.currentTimestamp() - (long)ModConfig.afk_auto_time.intValue() < eslPlayer.getTemp().getLastMoveTime()) continue;
                            TextUtils.sendGlobalMessage(players, "afk.maessentials.afk.true", player.func_145748_c_());
                            eslPlayer.getTemp().setAfk(true);
                            continue;
                        }
                        if (ModConfig.afk_auto_kick == 0 || TimeUtils.currentTimestamp() - (long)ModConfig.afk_auto_kick.intValue() < eslPlayer.getTemp().getLastMoveTime()) continue;
                        ModUtils.kickPlayer(player, new TranslationTextComponent("kick.maessentials.server", new Object[0]), new TranslationTextComponent("kick.maessentials.player", new Object[0]).func_150254_d());
                        continue;
                    }
                    if (eslPlayer.getTemp().isAfk()) {
                        TextUtils.sendGlobalMessage(players, "afk.maessentials.afk.false", player.func_145748_c_());
                        eslPlayer.getTemp().setAfk(false);
                    }
                    eslPlayer.getTemp().setLocation(playerLocation);
                }
            }
        }
        catch (Exception e) {
            System.out.println("checkAfk error:");
            System.out.println(e);
        }
    }
}

