/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.util;

import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.lib.Location;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public final class LocationUtils {
    public static boolean checkLocation(Location first, Location second) {
        return (int)first.x == (int)second.x && (int)first.y == (int)second.y && (int)first.z == (int)second.z && first.dimension == second.dimension;
    }

    public static boolean checkDetailedLocation(Location first, Location second) {
        return first.x == second.x && first.y == second.y && first.z == second.z && first.dimension == second.dimension && first.rotationPitch == second.rotationPitch && first.rotationYaw == second.rotationYaw;
    }

    public static Location findRandomTp(World world, Location spawnLocation, ServerPlayerEntity player, int count) {
        if (count == 10) {
            return null;
        }
        ++count;
        Random rand = new Random();
        int min = ModConfig.rndtp_range_min;
        int max = ModConfig.rndtp_range_max;
        int x = (int)Math.round(spawnLocation.x) + rand.nextInt(max + min) - min;
        int y = world.getMaxHeight();
        int z = (int)Math.round(spawnLocation.z) + rand.nextInt(max + min) - min;
        Chunk chunk = world.func_212866_a_(x >> 4, z >> 4);
        Biome biome = world.func_226691_t_(new BlockPos(x, y, z));
        if (biome.func_201856_r().func_222352_a().equals("ocean")) {
            return LocationUtils.findRandomTp(world, spawnLocation, player, count);
        }
        while (y > 0) {
            BlockPos headPos;
            BlockPos legPos;
            BlockPos groundPos;
            if (chunk.func_180495_p(groundPos = new BlockPos(x, --y - 2, z)).func_185904_a().equals(Material.field_151579_a) || chunk.func_180495_p(groundPos).func_177230_c().equals(Blocks.field_150357_h) || y - 2 == 1 || !chunk.func_180495_p(legPos = new BlockPos(x, y - 1, z)).func_185904_a().equals(Material.field_151579_a) || !chunk.func_180495_p(headPos = new BlockPos(x, y, z)).func_185904_a().equals(Material.field_151579_a)) continue;
            return new Location((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f, spawnLocation.getDimensionID());
        }
        return LocationUtils.findRandomTp(world, spawnLocation, player, count);
    }
}

