/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.islands.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.islands.helpers.WyHelper;

public class CommonConfig {
    private static final Path CONFIG_PATH = Paths.get("config", "islands-common.toml");
    public static final ForgeConfigSpec SPEC;
    public static final CommonConfig INSTANCE;
    private ForgeConfigSpec.IntValue islandRarity;
    private ForgeConfigSpec.IntValue islandMinSize;
    private ForgeConfigSpec.IntValue islandMaxSize;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> bannedBiomes;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> bannedOceans;
    private ForgeConfigSpec.BooleanValue survivalIsland;
    private ForgeConfigSpec.BooleanValue hasStartingBiome;
    private ForgeConfigSpec.ConfigValue<String> startingBiome;
    private static final Predicate<Object> ALLOWED_STRING_PREDICATE;

    public static void save() {
        SPEC.save();
    }

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Islands");
        this.islandRarity = builder.comment("Determines how rare islands will generate \nLower numbers means the islands will be more common!\n50 by default").defineInRange("Rarity", 50, 2, 10000);
        this.islandMinSize = builder.comment("The minimum size an island can be \n2 by default").defineInRange("Minimum Size", 2, 1, 10);
        this.islandMaxSize = builder.comment("The maximum size an island can be \n5 by default").defineInRange("Maximum Size", 5, 1, 10);
        this.survivalIsland = builder.comment("Determines if the spawn island is the only island spawned in the world \nfalse by default").define("Survival Island", false);
        this.hasStartingBiome = builder.comment("Determines if the starting biome (spawn island) is always the same or if its randomly chosen\nfalse by default").define("Has Starting Biome", false);
        this.startingBiome = builder.comment("Defines the starting biome (spawn island), only works if the 'Has Starting Biome' is set to true\nminecraft:forest by default").define("Starting Biome", (Object)"minecraft:forest");
        ArrayList<String> defaultBanListIslands = new ArrayList<String>();
        defaultBanListIslands.add(Biomes.field_76779_k.getRegistryName().toString());
        defaultBanListIslands.add(Biomes.field_201939_S.getRegistryName().toString());
        defaultBanListIslands.add(Biomes.field_201938_R.getRegistryName().toString());
        defaultBanListIslands.add(Biomes.field_201937_Q.getRegistryName().toString());
        defaultBanListIslands.add(Biomes.field_201936_P.getRegistryName().toString());
        defaultBanListIslands.add(Biomes.field_76779_k.getRegistryName().toString());
        defaultBanListIslands.add(Biomes.field_185440_P.getRegistryName().toString());
        this.bannedBiomes = builder.comment("List of banned biomes used for island generation, formated as resource keys <mod>:<biome> if <mod> is left out the system will treat them as vanilla biomes\nNote: If all the biomes are removed the Forest biome will be used as a default for all islands!").defineList("Banned Island Biomes", defaultBanListIslands, ALLOWED_STRING_PREDICATE);
        ArrayList defaultBanListOceans = new ArrayList();
        this.bannedOceans = builder.comment("List of banned biomes used for ocean generation, formated as resource keys <mod>:<biome> if <mod> is left out the system will treat them as vanilla biomes\nNote 1: While any biome can be added here if the biome is not an ocean it will have no effect on the ocean generation!\nNote 2: If all oceans are removed then the Deep Ocean biome will be used as a default!").defineList("Banned Ocean Biomes", defaultBanListOceans, ALLOWED_STRING_PREDICATE);
    }

    @Deprecated
    public Biome getStartingBiome() {
        ResourceLocation res = new ResourceLocation((String)this.startingBiome.get());
        return (Biome)ForgeRegistries.BIOMES.getValue(res);
    }

    @Deprecated
    public boolean hasStartingBiome() {
        return (Boolean)this.hasStartingBiome.get();
    }

    @Deprecated
    public List<String> getBannedOceanBiomes() {
        return (List)this.bannedOceans.get();
    }

    @Deprecated
    public boolean isSurvivalIsland() {
        return (Boolean)this.survivalIsland.get();
    }

    @Deprecated
    public List<String> getBannedIslandsBiomes() {
        return (List)this.bannedBiomes.get();
    }

    @Deprecated
    public int getIslandMaxSize() {
        return (Integer)this.islandMaxSize.get();
    }

    @Deprecated
    public int getIslandMinSize() {
        return (Integer)this.islandMinSize.get();
    }

    @Deprecated
    public int getIslandRarity() {
        return (Integer)this.islandRarity.get();
    }

    static {
        ALLOWED_STRING_PREDICATE = new Predicate<Object>(){

            @Override
            public boolean test(Object t) {
                if (!(t instanceof String)) {
                    return false;
                }
                String str = (String)t;
                return !WyHelper.isNullOrEmpty(str);
            }
        };
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        Pair pair = builder.configure(CommonConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (CommonConfig)pair.getLeft();
    }
}

