/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ChunkLoaderTileRenderer
extends TileEntityRenderer<ChunkLoaderTile> {
    private final Block block;
    private final boolean fullRotation;

    public ChunkLoaderTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn, Block block, boolean fullRotation) {
        super(rendererDispatcherIn);
        this.block = block;
        this.fullRotation = fullRotation;
    }

    public void render(ChunkLoaderTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        double offset = Math.sin((double)((float)((System.currentTimeMillis() + (long)tile.animationOffset) % 5000L) / 5000.0f * 2.0f) * Math.PI) * 0.1;
        matrixStack.func_227861_a_(0.0, offset, 0.0);
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        if (this.fullRotation) {
            float angleX = (float)((System.currentTimeMillis() + (long)tile.animationOffset) % 13000L) / 13000.0f * 360.0f;
            float angleY = (float)((System.currentTimeMillis() + (long)tile.animationOffset) % 15000L) / 15000.0f * 360.0f;
            float angleZ = (float)((System.currentTimeMillis() + (long)tile.animationOffset) % 16000L) / 16000.0f * 360.0f;
            matrixStack.func_227863_a_(new Quaternion(angleX, angleY, angleZ, true));
        } else {
            float angle = (float)((System.currentTimeMillis() + (long)tile.animationOffset) % 11000L) / 11000.0f * 360.0f;
            matrixStack.func_227863_a_(new Quaternion(0.0f, angle, 0.0f, true));
        }
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        for (RenderType type : RenderType.func_228661_n_()) {
            if (!RenderTypeLookup.canRenderInLayer((BlockState)this.block.func_176223_P(), (RenderType)type)) continue;
            BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            IBakedModel model = blockRenderer.func_184389_a(this.block.func_176223_P());
            blockRenderer.func_175019_b().renderModel((ILightReader)tile.func_145831_w(), model, this.block.func_176223_P(), tile.func_174877_v(), matrixStack, buffer.getBuffer(type), false, new Random(), 0L, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
        }
        matrixStack.func_227865_b_();
    }
}

