/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.chunkloaders.screen.ChunkImage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class ChunkButton
extends AbstractButton {
    private static final ResourceLocation BUTTON_OFF = new ResourceLocation("chunkloaders", "textures/gui/button_off.png");
    private static final ResourceLocation BUTTON_ON = new ResourceLocation("chunkloaders", "textures/gui/button_on.png");
    public final int xOffset;
    public final int zOffset;
    private final Supplier<ChunkLoaderTile> tileSupplier;
    private final ChunkImage image;

    public ChunkButton(int x, int y, int xOffset, int zOffset, Supplier<ChunkLoaderTile> tileSupplier, World world, ChunkPos chunk) {
        super(x, y, 15, 15, "");
        this.xOffset = xOffset;
        this.zOffset = zOffset;
        this.tileSupplier = tileSupplier;
        this.image = new ChunkImage(world, chunk);
        this.image.createTexture();
    }

    public void onPress() {
        ChunkLoaderTile tile = this.tileSupplier.get();
        if (tile != null) {
            ChunkLoaders.CHANNEL.sendToServer((Object)new PacketToggleChunk(tile.func_174877_v(), this.xOffset, this.zOffset));
        }
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(this.isLoaded() ? BUTTON_ON : BUTTON_OFF);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.drawTexture(this.x, this.y, 15, 15);
        this.image.updateTexture();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227760_t_((int)this.image.textureId);
        this.drawTexture(this.x + 2, this.y + 2, 11, 11);
        if (!this.isLoaded()) {
            this.fillGradient(this.x + 2, this.y + 2, this.x + 13, this.y + 13, -1442840576, -1442840576);
        }
        this.renderBg(minecraft, mouseX, mouseY);
    }

    public boolean isLoaded() {
        ChunkLoaderTile tile = this.tileSupplier.get();
        return tile != null && tile.isLoaded(this.xOffset, this.zOffset);
    }

    private void drawTexture(int x, int y, int width, int height) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int z = this.getBlitOffset();
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), (double)z).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), (double)z).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, (double)z).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, (double)z).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }
}

