/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.nio.ByteBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import org.lwjgl.opengl.GL11;

public class ChunkImage {
    private final World world;
    private final ChunkPos chunkPos;
    public int textureId = -1;
    private byte[] buffer = null;

    public ChunkImage(World world, ChunkPos chunkPos) {
        this.world = world;
        this.chunkPos = chunkPos;
    }

    public void createTexture() {
        this.textureId = TextureUtil.func_225678_a_();
    }

    public void updateTexture() {
        if (this.buffer == null) {
            this.buffer = this.createBuffer();
            GlStateManager.func_227760_t_((int)this.textureId);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.buffer.length);
            buffer.put(this.buffer).flip();
            GL11.glTexImage2D((int)3553, (int)0, (int)32849, (int)16, (int)16, (int)0, (int)6407, (int)5121, (ByteBuffer)buffer);
        }
    }

    private byte[] createBuffer() {
        int width = 16;
        int height = 16;
        byte[] rgbArray = new byte[width * height * 3];
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                BlockPos pos = this.world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(this.chunkPos.func_180334_c() + x, 0, this.chunkPos.func_180333_d() + z)).func_177977_b();
                int northY = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p() - 1) - 1;
                int westY = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n() - 1, pos.func_177952_p()) - 1;
                BlockState state = this.world.func_180495_p(pos);
                int rgb = state.func_185909_g((IBlockReader)this.world, (BlockPos)pos).field_76291_p;
                Color color = new Color(rgb);
                if (pos.func_177956_o() > northY && northY >= 0 || pos.func_177956_o() > westY && westY >= 0) {
                    color = color.brighter();
                }
                if (pos.func_177956_o() < northY && northY >= 0 || pos.func_177956_o() < westY && westY >= 0) {
                    color = color.darker();
                }
                rgb = color.getRGB();
                int index = (x * height + z) * 3;
                rgbArray[index] = (byte)(rgb >> 16 & 0xFF);
                rgbArray[index + 1] = (byte)(rgb >> 8 & 0xFF);
                rgbArray[index + 2] = (byte)(rgb & 0xFF);
            }
        }
        return rgbArray;
    }
}

