/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import com.supermartijn642.chunkloaders.screen.ChunkButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ChunkLoaderScreen
extends Screen {
    private static final ResourceLocation SCREEN_BACKGROUND = new ResourceLocation("chunkloaders", "textures/gui/background.png");
    protected World world;
    protected BlockPos pos;
    protected int left;
    protected int top;
    private final int backgroundSize;
    private boolean doDrag = false;
    private boolean dragState = false;
    private List<ChunkButton> draggedButtons = new ArrayList<ChunkButton>();

    public ChunkLoaderScreen(String type, World world, BlockPos pos) {
        super((ITextComponent)new TranslationTextComponent("block.chunkloaders." + type, new Object[0]));
        this.world = world;
        this.pos = pos;
        ChunkLoaderTile tile = this.getTileOrClose();
        int gridSize = tile == null ? 1 : tile.getGridSize();
        this.backgroundSize = gridSize * 15 + (gridSize - 1) + 16;
    }

    protected void init() {
        ChunkLoaderTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.left = (this.width - this.backgroundSize) / 2;
        this.top = (this.height - this.backgroundSize) / 2;
        int radius = (tile.getGridSize() - 1) / 2;
        for (int x = 0; x < tile.getGridSize(); ++x) {
            for (int y = 0; y < tile.getGridSize(); ++y) {
                this.addButton((Widget)new ChunkButton(this.left + 8 + x * 16, this.top + 8 + y * 16, -radius + x, -radius + y, this::getTileOrClose, this.world, new ChunkPos((this.pos.func_177958_n() >> 4) - radius + x, (this.pos.func_177952_p() >> 4) - radius + y)));
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        super.render(mouseX, mouseY, partialTicks);
        ChunkLoaderTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.buttons.stream().filter(ChunkButton.class::isInstance).map(ChunkButton.class::cast).forEach(button -> {
            if (button.isHovered()) {
                this.renderToolTip(true, "chunkloaders.gui." + (tile.isLoaded(button.xOffset, button.zOffset) ? "loaded" : "unloaded"), mouseX, mouseY);
            }
        });
    }

    private void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        ChunkLoaderTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.drawScreenBackground(this.left, this.top, this.backgroundSize, this.backgroundSize);
    }

    protected void drawCenteredString(ITextComponent text, float x, float y) {
        this.drawCenteredString(text.func_150254_d(), x, y);
    }

    protected void drawCenteredString(String s, float x, float y) {
        this.font.func_211126_b(s, (float)this.left + x - (float)this.font.func_78256_a(s) / 2.0f, (float)this.top + y, 0x404040);
    }

    protected void drawString(ITextComponent text, float x, float y) {
        this.drawString(text.func_150254_d(), x, y);
    }

    protected void drawString(String s, float x, float y) {
        this.font.func_211126_b(s, (float)this.left + x, (float)this.top + y, 0x404040);
    }

    public void renderToolTip(boolean translate, String string, int x, int y) {
        super.renderTooltip(translate ? new TranslationTextComponent(string, new Object[0]).func_150254_d() : string, x, y);
    }

    public ChunkLoaderTile getTileOrClose() {
        TileEntity tile;
        if (this.world != null && this.pos != null && (tile = this.world.func_175625_s(this.pos)) instanceof ChunkLoaderTile) {
            return (ChunkLoaderTile)tile;
        }
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
        return null;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (IGuiEventListener listener : this.children) {
                ChunkButton chunkButton;
                if (!(listener instanceof ChunkButton) || !(chunkButton = (ChunkButton)listener).isMouseOver(mouseX, mouseY)) continue;
                this.doDrag = true;
                this.dragState = !chunkButton.isLoaded();
                this.draggedButtons.clear();
                this.draggedButtons.add(chunkButton);
                chunkButton.onPress();
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.doDrag && button == 0) {
            for (IGuiEventListener listener : this.children) {
                ChunkButton chunkButton;
                if (!(listener instanceof ChunkButton) || this.draggedButtons.contains(listener) || !(chunkButton = (ChunkButton)listener).isMouseOver(mouseX, mouseY) || chunkButton.isLoaded() == this.dragState) continue;
                chunkButton.onPress();
                this.draggedButtons.add(chunkButton);
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.doDrag = false;
        }
        return false;
    }

    public void drawScreenBackground(float x, float y, float width, float height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SCREEN_BACKGROUND);
        this.drawTexture(x, y, 4.0f, 4.0f, 0.0f, 0.0f, 0.44444445f, 0.44444445f);
        this.drawTexture(x + width - 4.0f, y, 4.0f, 4.0f, 0.5555556f, 0.0f, 0.44444445f, 0.44444445f);
        this.drawTexture(x + width - 4.0f, y + height - 4.0f, 4.0f, 4.0f, 0.5555556f, 0.5555556f, 0.44444445f, 0.44444445f);
        this.drawTexture(x, y + height - 4.0f, 4.0f, 4.0f, 0.0f, 0.5555556f, 0.44444445f, 0.44444445f);
        this.drawTexture(x + 4.0f, y, width - 8.0f, 4.0f, 0.44444445f, 0.0f, 0.11111111f, 0.44444445f);
        this.drawTexture(x + 4.0f, y + height - 4.0f, width - 8.0f, 4.0f, 0.44444445f, 0.5555556f, 0.11111111f, 0.44444445f);
        this.drawTexture(x, y + 4.0f, 4.0f, height - 8.0f, 0.0f, 0.44444445f, 0.44444445f, 0.11111111f);
        this.drawTexture(x + width - 4.0f, y + 4.0f, 4.0f, height - 8.0f, 0.5555556f, 0.44444445f, 0.44444445f, 0.11111111f);
        this.drawTexture(x + 4.0f, y + 4.0f, width - 8.0f, height - 8.0f, 0.44444445f, 0.44444445f, 0.11111111f, 0.11111111f);
    }

    public void drawTexture(float x, float y, float width, float height, float tx, float ty, float twidth, float theight) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int z = this.getBlitOffset();
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), (double)z).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), (double)z).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, (double)z).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, (double)z).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }
}

