/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks;

import com.stateshifterlabs.achievementbooks.CommonProxy;
import com.stateshifterlabs.achievementbooks.commands.CreateDemoCommand;
import com.stateshifterlabs.achievementbooks.commands.GiveCommand;
import com.stateshifterlabs.achievementbooks.commands.ImportCommand;
import com.stateshifterlabs.achievementbooks.commands.ListCommand;
import com.stateshifterlabs.achievementbooks.commands.MainCommand;
import com.stateshifterlabs.achievementbooks.commands.ReloadCommand;
import com.stateshifterlabs.achievementbooks.data.AchievementStorage;
import com.stateshifterlabs.achievementbooks.data.Book;
import com.stateshifterlabs.achievementbooks.data.Books;
import com.stateshifterlabs.achievementbooks.data.GameSave;
import com.stateshifterlabs.achievementbooks.data.Loader;
import com.stateshifterlabs.achievementbooks.facade.MCSound;
import com.stateshifterlabs.achievementbooks.networking.MigrationNetworkAgent;
import com.stateshifterlabs.achievementbooks.networking.NetworkAgent;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid="achievementbooks", version="v1.0-MC1.10.2", name="achievementbooks", acceptedMinecraftVersions="[1.10.2]")
public class AchievementBooksMod {
    public static final String MODID = "achievementbooks";
    public static final String VERSION = "v1.0-MC1.10.2";
    @SidedProxy(serverSide="com.stateshifterlabs.achievementbooks.CommonProxy", clientSide="com.stateshifterlabs.achievementbooks.ClientProxy")
    public static CommonProxy proxy;
    private final AchievementStorage storage = new AchievementStorage();
    private Books books = new Books();
    private NetworkAgent networkAgent;
    private Loader loader;
    private File configDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configDir = new File(event.getSuggestedConfigurationFile().getParentFile().getAbsolutePath() + "/" + MODID);
        this.networkAgent = new NetworkAgent(this.storage);
        this.loader = new Loader(this.configDir, this.books, this.storage, this.networkAgent, new MCSound(), proxy);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.loader.init();
        new GameSave(this.storage, this.books, this.networkAgent);
        Book migrationTargetBook = this.books.migration();
        if (migrationTargetBook != null) {
            MigrationNetworkAgent migrationNetworkAgent = new MigrationNetworkAgent(migrationTargetBook, this.networkAgent, this.configDir, this.storage);
            FMLCommonHandler.instance().bus().register((Object)migrationNetworkAgent);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        MainCommand mainCommand = new MainCommand();
        mainCommand.add(new ReloadCommand(this.loader));
        mainCommand.add(new ImportCommand(this.loader, this.networkAgent, proxy.getDataDir()));
        mainCommand.add(new CreateDemoCommand(this.loader));
        mainCommand.add(new GiveCommand(this.books));
        mainCommand.add(new ListCommand(this.books));
        ICommandManager server = event.getServer().func_71187_D();
        ((ServerCommandManager)server).func_71560_a((ICommand)mainCommand);
    }
}

