/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.SA;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stateshifterlabs.achievementbooks.SA.NoSuchAchievementException;
import com.stateshifterlabs.achievementbooks.data.AchievementData;
import com.stateshifterlabs.achievementbooks.data.AchievementStorage;
import com.stateshifterlabs.achievementbooks.data.Book;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SaveDataDeserializer
implements JsonDeserializer<AchievementStorage> {
    private Book book;

    public SaveDataDeserializer(Book book) {
        this.book = book;
    }

    public AchievementStorage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        AchievementStorage storage = new AchievementStorage();
        if (!json.isJsonObject()) {
            return storage;
        }
        JsonObject root = json.getAsJsonObject();
        for (Map.Entry userEntry : root.entrySet()) {
            String username = (String)userEntry.getKey();
            JsonArray achievements = ((JsonElement)userEntry.getValue()).getAsJsonArray();
            AchievementData achievementData = storage.forPlayer(username);
            for (JsonElement achievement : achievements) {
                for (Map.Entry achievementEntry : achievement.getAsJsonObject().entrySet()) {
                    String achievementText = (String)achievementEntry.getKey();
                    boolean completed = ((JsonElement)achievementEntry.getValue()).getAsBoolean();
                    try {
                        String text = this.achievementText(achievementText);
                        int achievementId = this.book.findIdByAchievementText(text);
                        if (!completed) continue;
                        achievementData.toggle(this.book.itemName(), achievementId);
                    }
                    catch (NoSuchAchievementException noSuchAchievementException) {}
                }
            }
        }
        return storage;
    }

    private String achievementText(String text) {
        String firstPass = text.trim().replaceAll("[|]", "\n");
        String pattern = "(.*)\\s+\\[([^\\]]*)\\](\\s*)?";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(firstPass);
        if (m.find()) {
            String result = m.group(1);
            return result;
        }
        return firstPass;
    }
}

