/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.client.gui;

import com.stateshifterlabs.achievementbooks.client.gui.AchievementElementComposite;
import com.stateshifterlabs.achievementbooks.client.gui.AchievementLine;
import com.stateshifterlabs.achievementbooks.client.gui.DescriptionLine;
import com.stateshifterlabs.achievementbooks.client.gui.HeaderElementComposite;
import com.stateshifterlabs.achievementbooks.client.gui.PaginationButton;
import com.stateshifterlabs.achievementbooks.common.NBTUtils;
import com.stateshifterlabs.achievementbooks.data.AchievementData;
import com.stateshifterlabs.achievementbooks.data.Book;
import com.stateshifterlabs.achievementbooks.data.PageElement;
import com.stateshifterlabs.achievementbooks.data.Type;
import com.stateshifterlabs.achievementbooks.facade.Sound;
import com.stateshifterlabs.achievementbooks.networking.NetworkAgent;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUI
extends GuiScreen {
    private static ResourceLocation bgl;
    private static ResourceLocation bgr;
    private int nextButtonId;
    private int prevButtonId;
    private EntityPlayer player;
    private Book book;
    private NetworkAgent networkAgent;
    private Sound sound;
    private String nbttag;
    private int pageOffset = 0;
    private AchievementData achievementData;
    private int oldLeft = 0;
    private int oldTop = 0;
    private int clickDelay = 5;

    public GUI(EntityPlayer player, Book book, AchievementData achievementData, NetworkAgent networkAgent, Sound sound) {
        this.player = player;
        this.book = book;
        this.networkAgent = networkAgent;
        this.sound = sound;
        this.prevButtonId = this.getFreeId(new Integer[0]);
        this.nextButtonId = this.getFreeId(new Integer[]{this.prevButtonId});
        book.loadDone(achievementData.completed(book.itemName()));
        this.nbttag = "achievementbooks".toLowerCase() + ":" + book.itemName() + ":pageOffset";
        this.pageOffset = NBTUtils.getTag(player.func_184614_ca()).func_74762_e(this.nbttag);
        this.achievementData = achievementData;
        bgl = new ResourceLocation("achievementbooks".toLowerCase() + ":textures/gui/bookgui_left-" + book.colour() + ".png");
        bgr = new ResourceLocation("achievementbooks".toLowerCase() + ":textures/gui/bookgui_right-" + book.colour() + ".png");
    }

    public void initGui(int bookTop, int bookLeft) {
        AchievementElementComposite achievementElementComposite;
        DescriptionLine description;
        HeaderElementComposite header;
        int maxWidth = 173;
        int top = bookTop + 20;
        int left = bookLeft;
        this.clickDelay = 5;
        this.field_146292_n.clear();
        for (PageElement element : this.book.openPage(this.pageOffset).elements()) {
            if (element.type() == Type.HEADER) {
                header = new HeaderElementComposite(element.id(), element, top, left, maxWidth);
                this.field_146292_n.addAll(header.buttons());
                top += header.height();
            }
            if (element.type() == Type.TEXT) {
                description = new DescriptionLine(element.id(), left + 25, top, maxWidth, element.formattedDescription());
                this.field_146292_n.add(description);
                top += description.getHeight();
            }
            if (element.type() != Type.ACHIEVEMENT) continue;
            achievementElementComposite = new AchievementElementComposite(element.id(), element, top, left, maxWidth);
            this.field_146292_n.addAll(achievementElementComposite.buttons());
            top += achievementElementComposite.height();
        }
        top = bookTop + 20;
        try {
            if (this.pageOffset + 1 < this.book.pageCount()) {
                for (PageElement element : this.book.openPage(this.pageOffset + 1).elements()) {
                    if (element.type() == Type.HEADER) {
                        header = new HeaderElementComposite(element.id(), element, top, left + 208 - 15, maxWidth);
                        this.field_146292_n.addAll(header.buttons());
                        top += header.height();
                    }
                    if (element.type() == Type.TEXT) {
                        description = new DescriptionLine(element.id(), left + 25 + 208 - 15, top, maxWidth, element.formattedDescription());
                        this.field_146292_n.add(description);
                        top += description.getHeight();
                    }
                    if (element.type() != Type.ACHIEVEMENT) continue;
                    achievementElementComposite = new AchievementElementComposite(element.id(), element, top, left + 208 - 15, maxWidth);
                    this.field_146292_n.addAll(achievementElementComposite.buttons());
                    top += achievementElementComposite.height();
                }
            }
        }
        catch (NullPointerException e) {
            throw new RuntimeException(e);
        }
        if (this.pageOffset > 0) {
            this.field_146292_n.add(new PaginationButton(this.prevButtonId, bookLeft, bookTop + 245 - 23, false));
        }
        if (this.pageOffset + 1 < this.book.pageCount() - 1) {
            this.field_146292_n.add(new PaginationButton(this.nextButtonId, bookLeft + 417 - 22, bookTop + 245 - 23, true));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        this.clickDelay = Math.max(0, this.clickDelay - 1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int bookLeft = (this.field_146294_l - 417) / 2;
        int bookTop = (int)((double)(this.field_146295_m - 245) / 2.5);
        if (this.oldLeft != bookLeft || this.oldTop != bookTop) {
            this.oldLeft = bookLeft;
            this.oldTop = bookTop;
            this.initGui(bookTop, bookLeft);
        }
        this.field_146297_k.func_110434_K().func_110577_a(bgl);
        this.func_73729_b(bookLeft, bookTop, 0, 0, 208, 245);
        this.field_146297_k.func_110434_K().func_110577_a(bgr);
        this.func_73729_b(bookLeft + 208, bookTop, 0, 0, 208, 245);
        super.func_73863_a(mouseX, mouseY, par3);
    }

    public void func_146280_a(Minecraft mcInstance, int width, int height) {
        this.field_146297_k = mcInstance;
        this.field_146289_q = mcInstance.field_71466_p;
        this.field_146294_l = width;
        this.field_146295_m = height;
        int bookLeft = (this.field_146294_l - 417) / 2;
        int bookTop = (int)((double)(this.field_146295_m - 245) / 2.5);
        this.initGui(bookTop, bookLeft);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        this.sound.closeBook();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k != this.prevButtonId && button.field_146127_k != this.nextButtonId) {
            this.sound.toggle();
            ((AchievementLine)button).toggle();
            this.networkAgent.toggle(this.book, button.field_146127_k);
        } else if (this.clickDelay <= 0) {
            if (button.field_146127_k == this.prevButtonId) {
                this.previousPage();
            } else if (button.field_146127_k == this.nextButtonId) {
                this.nextPage();
            }
        }
    }

    private void nextPage() {
        int bookLeft = (this.field_146294_l - 417) / 2;
        int bookTop = (int)((double)(this.field_146295_m - 245) / 2.5);
        this.pageOffset += 2;
        this.sound.nextPage();
        this.initGui(bookTop, bookLeft);
        this.savePageNumber();
    }

    private void previousPage() {
        int bookLeft = (this.field_146294_l - 417) / 2;
        int bookTop = (int)((double)(this.field_146295_m - 245) / 2.5);
        this.pageOffset -= 2;
        this.sound.previousPage();
        this.initGui(bookTop, bookLeft);
        this.savePageNumber();
    }

    private void savePageNumber() {
        NBTUtils.getTag(this.player.func_184614_ca()).func_74768_a(this.nbttag, this.pageOffset);
        this.networkAgent.sendPageNumber(this.book, this.pageOffset);
    }

    private int getFreeId(Integer[] ints) {
        List<Integer> blacklist = Arrays.asList(ints);
        for (int i = -65535; i < 65535; ++i) {
            if (this.book.idExists(i) || blacklist.contains(i)) continue;
            return i;
        }
        throw new RuntimeException("Could not find an empty ID for buttons");
    }
}

