/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.commands;

import com.stateshifterlabs.achievementbooks.data.Book;
import com.stateshifterlabs.achievementbooks.data.Loader;
import com.stateshifterlabs.achievementbooks.data.compatibility.SA.SA;
import com.stateshifterlabs.achievementbooks.networking.NetworkAgent;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class ImportCommand
extends CommandBase {
    private final NetworkAgent networkAgent;
    private String dataDir;
    private Loader loader;

    public ImportCommand(Loader loader, NetworkAgent networkAgent, String dataDir) {
        this.loader = loader;
        this.networkAgent = networkAgent;
        this.dataDir = dataDir;
    }

    public int func_82362_a() {
        return 4;
    }

    public String func_71517_b() {
        return "import";
    }

    public String func_71518_a(ICommandSender sender) {
        return "import";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender.func_70005_c_().equalsIgnoreCase("server")) {
            return false;
        }
        return !sender.func_130014_f_().field_72995_K;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender.func_130014_f_().field_72995_K || sender.func_70005_c_().equalsIgnoreCase("server") || !((EntityPlayerMP)sender).field_71133_b.func_71264_H()) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("ab.command.import.error.multiplayer.error", new Object[0]));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("ab.command.import.error.multiplayer.advice", new Object[0]));
            return;
        }
        SA importer = new SA(this.dataDir);
        Book newBook = importer.createElementList(importer.parseFormattings());
        importer.saveBook(newBook);
        this.loader.init();
        importer.parseSaveData(newBook, this.networkAgent);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("achievementbooks", newBook.itemName()));
        sender.func_130014_f_().func_72924_a((String)sender.func_70005_c_()).field_71071_by.func_70441_a(new ItemStack(item, 1));
        sender.func_145747_a((ITextComponent)new TextComponentString("Finished importing the achievement book."));
        sender.func_145747_a((ITextComponent)new TextComponentString("New book file created in config/achievementbooks/imported_achievement_book.json"));
        sender.func_145747_a((ITextComponent)new TextComponentString("It's not going to be perfect, but gets the most of the job done."));
    }
}

