/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.data;

import com.stateshifterlabs.achievementbooks.data.Save;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AchievementData {
    private final String player;
    private final Map<String, Save> bookData = new HashMap<String, Save>();

    public AchievementData(String player) {
        this.player = player;
    }

    public String username() {
        return this.player;
    }

    public Set<String> books() {
        return this.bookData.keySet();
    }

    public void addSaveData(String bookName, Save save) {
        if (this.bookData.containsKey(bookName)) {
            this.bookData.remove(bookName);
        }
        this.bookData.put(bookName, save);
    }

    public List<Integer> completed(String bookName) {
        if (!this.bookData.containsKey(bookName)) {
            this.addSaveData(bookName, new Save());
        }
        return this.bookData.get(bookName).completedAchievements();
    }

    public void toggle(String bookName, int id) {
        if (!this.bookData.containsKey(bookName)) {
            this.addSaveData(bookName, new Save());
        }
        this.bookData.get(bookName).toggle(id);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AchievementData)) {
            return false;
        }
        AchievementData that = (AchievementData)o;
        if (this.player != null ? !this.player.equals(that.player) : that.player != null) {
            return false;
        }
        return this.bookData != null ? this.bookData.equals(that.bookData) : that.bookData == null;
    }

    public final int hashCode() {
        int result = this.player != null ? this.player.hashCode() : 0;
        result = 31 * result + (this.bookData != null ? this.bookData.hashCode() : 0);
        return result;
    }
}

