/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.data;

import com.stateshifterlabs.achievementbooks.data.AchievementData;
import com.stateshifterlabs.achievementbooks.facade.Player;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AchievementStorage {
    private final Map<String, AchievementData> storage = new HashMap<String, AchievementData>();

    public void append(AchievementData data) {
        if (this.storage.containsKey(data.username())) {
            this.storage.remove(data.username());
        }
        this.storage.put(data.username(), data);
    }

    public boolean hasPlayerData(String name) {
        return this.storage.containsKey(name);
    }

    public AchievementData forPlayer(Player player) {
        String name = player.getDisplayName();
        return this.forPlayer(name);
    }

    public List<String> players() {
        if (this.storage.size() == 0) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.storage.keySet());
    }

    public AchievementData forPlayer(String name) {
        if (this.storage.containsKey(name)) {
            return this.storage.get(name);
        }
        AchievementData achievementData = new AchievementData(name);
        this.append(achievementData);
        return achievementData;
    }

    public void clear() {
        this.storage.clear();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AchievementStorage)) {
            return false;
        }
        AchievementStorage that = (AchievementStorage)o;
        return this.storage != null ? this.storage.equals(that.storage) : that.storage == null;
    }

    public final int hashCode() {
        return this.storage != null ? this.storage.hashCode() : 0;
    }

    public int size() {
        return this.storage.size();
    }
}

