/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.data;

import com.stateshifterlabs.achievementbooks.SA.NoSuchAchievementException;
import com.stateshifterlabs.achievementbooks.data.DuplicatePageElementIdException;
import com.stateshifterlabs.achievementbooks.data.Language;
import com.stateshifterlabs.achievementbooks.data.Page;
import com.stateshifterlabs.achievementbooks.data.PageElement;
import com.stateshifterlabs.achievementbooks.data.Type;
import com.stateshifterlabs.achievementbooks.items.Colour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Book {
    private final Map<Integer, Page> pages = new HashMap<Integer, Page>();
    private final List<Integer> elementIds = new ArrayList<Integer>();
    private int addedPages = 0;
    private String name = "";
    private String craftingMaterial = "";
    private boolean craftable = false;
    private String itemName = "";
    private Colour colour = Colour.defaultColour();
    private Language language = Language.UK;
    private boolean isMigrationTarget = false;

    public void withName(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public void withItemName(String name) {
        this.itemName = name;
    }

    public String itemName() {
        return this.itemName;
    }

    public void withMaterial(String material) {
        this.craftingMaterial = material;
        this.craftable = true;
    }

    public String material() {
        return this.craftingMaterial;
    }

    public Book withColour(String colour) {
        this.colour = Colour.fromString(colour);
        return this;
    }

    public String colour() {
        return this.colour.getText();
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    public void addPage(Page page) {
        this.pages.put(this.addedPages++, page);
        for (PageElement element : page.elements()) {
            if (this.elementIds.contains(element.id())) {
                throw new DuplicatePageElementIdException(element, this.name());
            }
            this.elementIds.add(element.id());
        }
    }

    public int pageCount() {
        return this.pages.size();
    }

    public Page openPage(int pageNumber) {
        if (!this.pages.containsKey(pageNumber)) {
            return new Page();
        }
        return this.pages.get(pageNumber);
    }

    public void loadDone(List<Integer> ids) {
        for (Page page : this.pages.values()) {
            for (PageElement element : page.elements()) {
                if (!ids.contains(element.id())) continue;
                element.toggleState(true);
            }
        }
    }

    public int findIdByAchievementText(String text) throws NoSuchAchievementException {
        for (Page page : this.pages.values()) {
            for (PageElement element : page.elements()) {
                if (element.type() != Type.ACHIEVEMENT || !element.achievement().equalsIgnoreCase(text)) continue;
                return element.id();
            }
        }
        throw new NoSuchAchievementException();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Book)) {
            return false;
        }
        Book book = (Book)o;
        if (this.addedPages != book.addedPages) {
            return false;
        }
        if (this.craftable != book.craftable) {
            return false;
        }
        if (this.elementIds != null ? !this.elementIds.equals(book.elementIds) : book.elementIds != null) {
            return false;
        }
        if (this.pages != null ? !this.pages.equals(book.pages) : book.pages != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(book.name) : book.name != null) {
            return false;
        }
        if (this.craftingMaterial != null ? !this.craftingMaterial.equals(book.craftingMaterial) : book.craftingMaterial != null) {
            return false;
        }
        if (this.itemName != null ? !this.itemName.equals(book.itemName) : book.itemName != null) {
            return false;
        }
        if (this.isMigrationTarget != book.isMigrationTarget) {
            return false;
        }
        if (this.colour != book.colour) {
            return false;
        }
        return this.language != null ? this.language.equals((Object)book.language) : book.language == null;
    }

    public final int hashCode() {
        int result = this.pages != null ? this.pages.hashCode() : 0;
        result = 31 * result + this.addedPages;
        if (this.elementIds != null) {
            result = 31 * result + this.elementIds.hashCode();
        }
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.craftingMaterial != null ? this.craftingMaterial.hashCode() : 0);
        result = 31 * result + (this.craftable ? 1 : 0);
        result = 31 * result + (this.isMigrationTarget ? 1 : 0);
        result = 31 * result + (this.itemName != null ? this.itemName.hashCode() : 0);
        result = 31 * result + (this.colour != null ? this.colour.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        return result;
    }

    public void withLanguage(Language language) {
        this.language = language;
    }

    public Language language() {
        return this.language;
    }

    public int numberOfElements() {
        return this.elementIds.size();
    }

    public boolean idExists(int existingId) {
        return this.elementIds.contains(existingId);
    }

    public boolean isMigrationTarget() {
        return this.isMigrationTarget;
    }

    public void markAsMigrationTarget() {
        this.isMigrationTarget = true;
    }
}

