/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.stateshifterlabs.achievementbooks.data.AchievementStorage;
import com.stateshifterlabs.achievementbooks.data.Books;
import com.stateshifterlabs.achievementbooks.networking.NetworkAgent;
import com.stateshifterlabs.achievementbooks.serializers.AchievementStorageSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GameSave {
    private final Gson gson;
    private File saveDir;
    private AchievementStorage storage;
    private Books books;
    private NetworkAgent networkAgent;

    public GameSave(AchievementStorage storage, Books books, NetworkAgent networkAgent) {
        this.storage = storage;
        this.books = books;
        this.books = books;
        this.networkAgent = networkAgent;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(AchievementStorage.class, (Object)new AchievementStorageSerializer(storage));
        this.gson = builder.create();
    }

    public void load() {
        File saveFile;
        this.saveDir = new File(DimensionManager.getCurrentSaveRootDirectory().getAbsolutePath() + "/" + "achievementbooks".toLowerCase());
        if (!this.saveDir.exists()) {
            this.saveDir.mkdirs();
        }
        if (!(saveFile = new File(this.saveDir.getAbsolutePath() + "/achievementbooks.save.json")).exists()) {
            return;
        }
        try {
            this.storage.clear();
            this.storage = (AchievementStorage)this.gson.fromJson((Reader)new FileReader(saveFile), AchievementStorage.class);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void save() {
        this.saveDir = new File(DimensionManager.getCurrentSaveRootDirectory().getAbsolutePath() + "/" + "achievementbooks".toLowerCase());
        this.saveDir.mkdirs();
        this.save(this.storage);
    }

    public void save(AchievementStorage storage) {
        File saveFile = new File(this.saveDir.getAbsolutePath() + "/achievementbooks.save.json");
        String saveData = this.gson.toJson((Object)storage);
        try {
            FileWriter fw = new FileWriter(saveFile);
            fw.write(saveData);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load load) {
        if (!load.getWorld().field_72995_K) {
            this.load();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save save) {
        if (!save.getWorld().field_72995_K) {
            this.save();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.save();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player != null && !player.field_70170_p.field_72995_K) {
            this.networkAgent.sendAchievementsTo((EntityPlayerMP)player);
        }
    }
}

