/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.data;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.stateshifterlabs.achievementbooks.AchievementBooksMod;
import com.stateshifterlabs.achievementbooks.CommonProxy;
import com.stateshifterlabs.achievementbooks.data.AchievementStorage;
import com.stateshifterlabs.achievementbooks.data.Book;
import com.stateshifterlabs.achievementbooks.data.Books;
import com.stateshifterlabs.achievementbooks.data.DemoAlreadyExistsException;
import com.stateshifterlabs.achievementbooks.data.JsonParseError;
import com.stateshifterlabs.achievementbooks.facade.Sound;
import com.stateshifterlabs.achievementbooks.items.AchievementBookItem;
import com.stateshifterlabs.achievementbooks.networking.NetworkAgent;
import com.stateshifterlabs.achievementbooks.serializers.BookSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.commons.io.FileUtils;

public class Loader {
    private final AchievementStorage storage;
    private final NetworkAgent networkAgent;
    private Sound sound;
    private CommonProxy proxy;
    private File configDir;
    private Books books;
    private Map<String, AchievementBookItem> items = new HashMap<String, AchievementBookItem>();

    public Loader(File configDir, Books books, AchievementStorage storage, NetworkAgent networkAgent, Sound sound, CommonProxy proxy) {
        this.configDir = configDir;
        this.books = books;
        this.storage = storage;
        this.networkAgent = networkAgent;
        this.sound = sound;
        this.proxy = proxy;
    }

    public Books init() {
        return this.init(false);
    }

    public Books init(boolean createDemo) {
        File[] files;
        this.books.empty();
        FilenameFilter fileNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int lastIndex;
                String str;
                return name.lastIndexOf(46) > 0 && (str = name.substring(lastIndex = name.lastIndexOf(46))).equals(".json");
            }
        };
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
        if ((files = this.configDir.listFiles(fileNameFilter)).length == 0 || createDemo) {
            File file = new File(this.configDir.getAbsolutePath() + "/demo.json");
            if (file.exists()) {
                throw new DemoAlreadyExistsException();
            }
            URL url = AchievementBooksMod.class.getResource("/config/demo.json");
            try {
                FileUtils.copyURLToFile((URL)url, (File)file);
                return this.init();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (File conf : files) {
            try {
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.registerTypeAdapter(Book.class, (Object)new BookSerializer(conf));
                Gson gson = gsonBuilder.create();
                try {
                    Book book = (Book)gson.fromJson((Reader)new BufferedReader(Files.newReader((File)conf, (Charset)Charset.defaultCharset())), Book.class);
                    this.books.addBook(book);
                }
                catch (JsonSyntaxException e) {
                    throw new JsonParseError("There is an error in the book config. Use http://jsonlint.com/ to find it", conf);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.buildItems();
        return this.books;
    }

    public AchievementStorage storage() {
        return this.storage;
    }

    private void buildItems() {
        for (Book book : this.books) {
            if (this.items.containsKey(book.itemName())) {
                this.items.get(book.itemName()).updateBook(book);
                continue;
            }
            AchievementBookItem achievementBook = new AchievementBookItem(book, this.storage, this.networkAgent, this.sound);
            String name = String.format("book-%s", book.colour());
            this.proxy.registerItemRenderer(achievementBook, 0, name);
            GameRegistry.register((IForgeRegistryEntry)achievementBook);
            if (book.isCraftable()) {
                ItemStack itemStack = new ItemStack((Item)achievementBook);
                GameRegistry.addRecipe((ItemStack)itemStack, (Object[])new Object[]{"AB", Character.valueOf('A'), Items.field_151122_aG, Character.valueOf('B'), Item.func_111206_d((String)book.material())});
            }
            this.items.put(book.itemName(), achievementBook);
        }
    }
}

