/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.data;

import com.stateshifterlabs.achievementbooks.ChatFormatting;
import com.stateshifterlabs.achievementbooks.UTF8Utils;
import com.stateshifterlabs.achievementbooks.data.Type;

public class PageElement {
    private String achievement;
    private String description;
    private String header;
    private String mod;
    private boolean checked = false;
    private int id;

    public PageElement(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public String achievement() {
        return this.achievement;
    }

    public String formattedAchievement() {
        if (!this.hasAchievement()) {
            return "";
        }
        if (this.hasMod()) {
            return String.format("%s %s", UTF8Utils.utf8String(this.achievement), this.formattedMod());
        }
        return String.format("%s", UTF8Utils.utf8String(this.achievement));
    }

    public void withAchievement(String achievement) {
        if (!this.hasAchievement()) {
            this.achievement = achievement;
        }
    }

    public boolean hasAchievement() {
        return this.achievement() != null;
    }

    public String formattedDescription() {
        if (!this.hasDescription()) {
            return "";
        }
        return UTF8Utils.utf8String(ChatFormatting.ITALIC.toString(), String.format("%s", this.description));
    }

    public String description() {
        return this.description;
    }

    public void withDescription(String description) {
        if (!this.hasDescription()) {
            this.description = description;
        }
    }

    public boolean hasDescription() {
        return this.description() != null;
    }

    public String header() {
        return this.header;
    }

    public String formattedHeader() {
        if (!this.hasHeader()) {
            return "";
        }
        return UTF8Utils.utf8String(ChatFormatting.BOLD.toString(), this.header);
    }

    public void withHeader(String header) {
        if (!this.hasHeader()) {
            this.header = header;
        }
    }

    public boolean hasHeader() {
        return this.header() != null;
    }

    public String mod() {
        return this.mod;
    }

    public String formattedMod() {
        if (!this.hasMod()) {
            return "";
        }
        return UTF8Utils.utf8String(ChatFormatting.DARK_BLUE.toString(), ChatFormatting.ITALIC.toString(), String.format("[%s]", this.mod), ChatFormatting.RESET.toString());
    }

    public void withMod(String mod) {
        if (!this.hasMod()) {
            this.mod = mod;
        }
    }

    public boolean hasMod() {
        return this.mod() != null;
    }

    public void toggleState() {
        this.checked = !this.checked;
    }

    public void toggleState(boolean checked) {
        this.checked = checked;
    }

    public boolean checked() {
        return this.checked;
    }

    public Type type() {
        if (this.achievement != null) {
            return Type.ACHIEVEMENT;
        }
        if (this.header != null) {
            return Type.HEADER;
        }
        return Type.TEXT;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageElement)) {
            return false;
        }
        PageElement that = (PageElement)o;
        if (this.checked != that.checked) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.achievement != null ? !this.achievement.equals(that.achievement) : that.achievement != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.header != null ? !this.header.equals(that.header) : that.header != null) {
            return false;
        }
        return this.mod != null ? this.mod.equals(that.mod) : that.mod == null;
    }

    public final int hashCode() {
        int result = this.achievement != null ? this.achievement.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.header != null ? this.header.hashCode() : 0);
        result = 31 * result + (this.mod != null ? this.mod.hashCode() : 0);
        result = 31 * result + (this.checked ? 1 : 0);
        result = 31 * result + this.id;
        return result;
    }
}

