/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.networking;

import com.stateshifterlabs.achievementbooks.data.AchievementData;
import com.stateshifterlabs.achievementbooks.data.AchievementStorage;
import com.stateshifterlabs.achievementbooks.data.Book;
import com.stateshifterlabs.achievementbooks.data.compatibility.SA.SA;
import com.stateshifterlabs.achievementbooks.networking.MigrationClientHandler;
import com.stateshifterlabs.achievementbooks.networking.MigrationCompletionDetailsMessage;
import com.stateshifterlabs.achievementbooks.networking.NetworkAgent;
import java.io.File;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MigrationNetworkAgent {
    private final AchievementStorage storage;
    private SimpleNetworkWrapper wrapper;
    private Book targetBook;
    private NetworkAgent networkAgent;
    private File configDir;
    private int packetId = 10000;
    private int delay = 160;
    private int delayServer = 160;
    private final SA importer;

    public MigrationNetworkAgent(Book targetBook, NetworkAgent networkAgent, File configDir, AchievementStorage mainStorage) {
        this.importer = new SA(configDir.getAbsolutePath());
        this.storage = mainStorage;
        this.targetBook = targetBook;
        this.networkAgent = networkAgent;
        this.configDir = configDir;
        String channelName = String.format("mezamigr", new Object[0]);
        this.wrapper = new SimpleNetworkWrapper(channelName);
        this.wrapper.registerMessage((IMessageHandler)new MigrationClientHandler(mainStorage), MigrationCompletionDetailsMessage.class, this.packetId++, Side.CLIENT);
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player != null && !player.field_70170_p.field_72995_K) {
            AchievementData data = this.importer.getUserSave(player.func_70005_c_(), this.targetBook);
            this.storage.append(data);
            this.sendMigrationCompletedAchievements((EntityPlayerMP)player, data);
        }
    }

    private void sendMigrationCompletedAchievements(EntityPlayerMP player, AchievementData data) {
        MigrationCompletionDetailsMessage completionDetailsMessage = new MigrationCompletionDetailsMessage();
        completionDetailsMessage.withData(data);
        this.wrapper.sendTo((IMessage)completionDetailsMessage, player);
    }

    public Item getBook() {
        return Item.func_111206_d((String)"simpleachievements:achievement_book");
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onServerPlayerTick(TickEvent.PlayerTickEvent event) {
        --this.delayServer;
        if (this.delayServer > 1) {
            return;
        }
        this.delayServer = 160;
        EntityPlayer player = event.player;
        Item SAbook = this.getBook();
        InventoryPlayer inventory = player.field_71071_by;
        AchievementData userSave = this.importer.getUserSave(event.player.func_70005_c_(), this.targetBook);
        this.storage.append(userSave);
        this.updatePlayerInventory(event, SAbook, inventory);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        --this.delay;
        if (this.delay > 1) {
            return;
        }
        this.delay = 160;
        Item SAbook = this.getBook();
        InventoryPlayer inventory = event.player.field_71071_by;
        if (!event.player.func_130014_f_().field_72995_K) {
            AchievementData userSave = this.importer.getUserSave(event.player.func_70005_c_(), this.targetBook);
            this.networkAgent.sendCompletedAchievements(userSave);
            this.updatePlayerInventory(event, SAbook, inventory);
        }
    }

    private void updatePlayerInventory(TickEvent.PlayerTickEvent event, Item SAbook, InventoryPlayer inventory) {
        if (inventory.func_70431_c(new ItemStack(SAbook, 1))) {
            Item theBook = Item.func_111206_d((String)("achievementbooks:" + this.targetBook.itemName()));
            int inventorySize = inventory.func_70302_i_();
            for (int i = 0; i < inventorySize; ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != SAbook) continue;
                inventory.func_70299_a(i, (ItemStack)null);
                if (!event.player.field_70170_p.field_72995_K) {
                    this.networkAgent.sendAchievementsTo((EntityPlayerMP)event.player);
                }
                ItemStack newBook = new ItemStack(theBook, 1);
                inventory.func_70299_a(i, newBook);
            }
        }
    }
}

