/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.networking;

import com.stateshifterlabs.achievementbooks.data.AchievementData;
import com.stateshifterlabs.achievementbooks.data.AchievementStorage;
import com.stateshifterlabs.achievementbooks.data.Book;
import com.stateshifterlabs.achievementbooks.networking.ClientHandler;
import com.stateshifterlabs.achievementbooks.networking.CompletionDetailsMessage;
import com.stateshifterlabs.achievementbooks.networking.PageTurnMessage;
import com.stateshifterlabs.achievementbooks.networking.ServerPageTurnHandler;
import com.stateshifterlabs.achievementbooks.networking.ServerToggleHandler;
import com.stateshifterlabs.achievementbooks.networking.ToggleAchievementMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkAgent {
    private SimpleNetworkWrapper wrapper;
    private AchievementStorage storage;
    private int packetId = 0;

    public NetworkAgent(AchievementStorage storage) {
        this.storage = storage;
        String channelName = String.format("meza", new Object[0]);
        this.wrapper = new SimpleNetworkWrapper(channelName);
        this.wrapper.registerMessage((IMessageHandler)new ClientHandler(storage), CompletionDetailsMessage.class, this.packetId++, Side.CLIENT);
        this.wrapper.registerMessage((IMessageHandler)new ClientHandler(storage), CompletionDetailsMessage.class, this.packetId++, Side.SERVER);
        this.wrapper.registerMessage((IMessageHandler)new ServerToggleHandler(storage, this), ToggleAchievementMessage.class, this.packetId++, Side.SERVER);
        this.wrapper.registerMessage((IMessageHandler)new ServerPageTurnHandler(storage), PageTurnMessage.class, this.packetId++, Side.SERVER);
    }

    public void sendPageNumber(Book book, int pageOffset) {
        PageTurnMessage msg = new PageTurnMessage();
        msg.withData(book.itemName(), pageOffset);
        this.wrapper.sendToServer((IMessage)msg);
    }

    public void toggle(Book book, int id) {
        ToggleAchievementMessage msg = new ToggleAchievementMessage();
        msg.withData(book.itemName(), id);
        this.wrapper.sendToServer((IMessage)msg);
    }

    public void sendAchievementsTo(EntityPlayerMP player) {
        CompletionDetailsMessage msg = new CompletionDetailsMessage();
        msg.withData(this.storage.forPlayer(player.func_70005_c_()));
        this.wrapper.sendTo((IMessage)msg, player);
    }

    public void sendCompletedAchievements(AchievementData data) {
        CompletionDetailsMessage msg = new CompletionDetailsMessage();
        msg.withData(data);
        this.wrapper.sendToServer((IMessage)msg);
    }
}

