/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.networking;

import com.stateshifterlabs.achievementbooks.facade.ByteBufferUtilities;
import com.stateshifterlabs.achievementbooks.facade.NetworkMessage;
import io.netty.buffer.ByteBuf;

public class PageTurnMessageBase
implements NetworkMessage {
    private String bookName;
    private int pageOffset;
    private ByteBufferUtilities bufferUtilities;

    public PageTurnMessageBase(ByteBufferUtilities bufferUtilities) {
        this.bufferUtilities = bufferUtilities;
    }

    public PageTurnMessageBase withData(String bookName, int pageOffset) {
        this.bookName = bookName;
        this.pageOffset = pageOffset;
        return this;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.pageOffset = buf.readInt();
        this.bookName = this.bufferUtilities.readUTF8String(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pageOffset);
        this.bufferUtilities.writeUTF8String(buf, this.bookName);
    }

    public int page() {
        return this.pageOffset;
    }

    public String bookName() {
        return this.bookName;
    }
}

