/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.networking;

import com.stateshifterlabs.achievementbooks.facade.ByteBufferUtilities;
import com.stateshifterlabs.achievementbooks.facade.NetworkMessage;
import io.netty.buffer.ByteBuf;

public class ToggleAchievementMessageBase
implements NetworkMessage {
    private String bookName;
    private int achievementId;
    private ByteBufferUtilities bufferUtilities;

    public ToggleAchievementMessageBase(ByteBufferUtilities bufferUtilities) {
        this.bufferUtilities = bufferUtilities;
    }

    public ToggleAchievementMessageBase withData(String bookName, int achievmenetId) {
        this.bookName = bookName;
        this.achievementId = achievmenetId;
        return this;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.achievementId = buf.readInt();
        this.bookName = this.bufferUtilities.readUTF8String(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.achievementId);
        this.bufferUtilities.writeUTF8String(buf, this.bookName);
    }

    public int achievementId() {
        return this.achievementId;
    }

    public String bookName() {
        return this.bookName;
    }
}

