/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.stateshifterlabs.achievementbooks.data.AchievementData;
import com.stateshifterlabs.achievementbooks.data.Save;
import java.lang.reflect.Type;

public class AchievementDataSerializer
implements JsonSerializer<AchievementData>,
JsonDeserializer<AchievementData> {
    private String player;

    public AchievementDataSerializer(String player) {
        this.player = player;
    }

    public JsonElement serialize(AchievementData data, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject playerJson = new JsonObject();
        playerJson.addProperty("name", this.player);
        JsonArray books = new JsonArray();
        for (String bookName : data.books()) {
            JsonObject book = new JsonObject();
            book.addProperty("name", bookName);
            JsonArray checked = new JsonArray();
            for (Integer id : data.completed(bookName)) {
                JsonPrimitive checkedId = new JsonPrimitive((Number)id);
                checked.add((JsonElement)checkedId);
            }
            book.add("checked", (JsonElement)checked);
            books.add((JsonElement)book);
        }
        playerJson.add("books", (JsonElement)books);
        return playerJson;
    }

    public AchievementData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject userSaveAsJsonObject = json.getAsJsonObject();
        AchievementData data = new AchievementData(userSaveAsJsonObject.get("name").getAsString());
        JsonArray booksJson = userSaveAsJsonObject.get("books").getAsJsonArray();
        for (JsonElement bookJson : booksJson) {
            Save save = new Save();
            JsonObject bookJsonObject = bookJson.getAsJsonObject();
            String name = bookJsonObject.get("name").getAsString();
            JsonArray checked = bookJsonObject.getAsJsonArray("checked");
            for (JsonElement checkedId : checked) {
                save.toggle(checkedId.getAsInt());
            }
            data.addSaveData(name, save);
        }
        return data;
    }
}

