/*
 * Decompiled with CFR 0.152.
 */
package com.stateshifterlabs.achievementbooks.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.stateshifterlabs.achievementbooks.data.AchievementData;
import com.stateshifterlabs.achievementbooks.data.AchievementStorage;
import com.stateshifterlabs.achievementbooks.serializers.AchievementDataSerializer;
import java.lang.reflect.Type;

public class AchievementStorageSerializer
implements JsonSerializer<AchievementStorage>,
JsonDeserializer<AchievementStorage> {
    private AchievementStorage storage;

    public AchievementStorageSerializer(AchievementStorage storage) {
        this.storage = storage;
    }

    public JsonElement serialize(AchievementStorage src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray storage = new JsonArray();
        for (String player : src.players()) {
            AchievementData data = src.forPlayer(player);
            AchievementDataSerializer dataSer = new AchievementDataSerializer(player);
            JsonElement playerJson = dataSer.serialize(data, (Type)((Object)AchievementData.class), context);
            storage.add(playerJson);
        }
        return storage;
    }

    public AchievementStorage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonArray storageJson = json.getAsJsonArray();
        for (JsonElement userSave : storageJson) {
            String thePlayer = userSave.getAsJsonObject().get("name").getAsString();
            AchievementDataSerializer ser = new AchievementDataSerializer(thePlayer);
            AchievementData data = ser.deserialize(userSave, (Type)((Object)AchievementData.class), context);
            this.storage.append(data);
        }
        return this.storage;
    }
}

