/*
 * Decompiled with CFR 0.152.
 */
package aquacreeper;

import aquacreeper.confighandler.ConfigHandler;
import aquacreeper.entities.EntityAquaCreeper;
import aquacreeper.network.ExplosionPacketHandler;
import aquacreeper.network.ParticleMessage;
import aquacreeper.proxy.CommonProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="aquacreeper", name="aquacreeper", version="1.2.1", guiFactory="aquacreeper.confighandler.ConfigGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class AquaCreeper {
    @SidedProxy(clientSide="aquacreeper.proxy.ClientProxy", serverSide="aquacreeper.proxy.CommonProxy")
    public static CommonProxy PROXY;
    public static SimpleNetworkWrapper NETWORK_WRAPPER;
    static int START_ENTITY_ID;
    public static SoundEvent AQUACREEPER_HURT;
    public static SoundEvent AQUACREEPER_SWIM;
    public static SoundEvent UNDERWATER_EXPLOSION;
    public static SoundEvent UNDERWATER_FUSE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.INSTANCE.loadConfig(event);
        EntityRegistry.registerModEntity(EntityAquaCreeper.class, (String)"Aqua Creeper", (int)1, (Object)this, (int)120, (int)1, (boolean)true);
        EntitySpawnPlacementRegistry.setPlacementType(EntityAquaCreeper.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        AquaCreeper.registerEntityEgg(EntityAquaCreeper.class, 4489885, 10475728);
        for (Biome allBiomes : ForgeRegistries.BIOMES.getValues()) {
            if (!BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) && !BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) continue;
            EntityRegistry.addSpawn(EntityAquaCreeper.class, (int)ConfigHandler.AQUA_CREEPER_SPAWN_PROBABILITY, (int)ConfigHandler.AQUA_CREEPER_MIN_SPAWN_SIZE, (int)ConfigHandler.AQUA_CREEPER_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
        }
        NETWORK_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("aquacreeper");
        NETWORK_WRAPPER.registerMessage(ExplosionPacketHandler.class, ParticleMessage.class, 0, Side.CLIENT);
        PROXY.registerRenderInformation();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        AQUACREEPER_HURT = (SoundEvent)new SoundEvent(new ResourceLocation("aquacreeper", "aquacreeperhurt")).setRegistryName("aquacreeper", "aquacreeperhurt");
        GameRegistry.register((IForgeRegistryEntry)AQUACREEPER_HURT);
        AQUACREEPER_SWIM = (SoundEvent)new SoundEvent(new ResourceLocation("aquacreeper", "aquacreeperswim")).setRegistryName("aquacreeper", "aquacreeperswim");
        GameRegistry.register((IForgeRegistryEntry)AQUACREEPER_SWIM);
        UNDERWATER_EXPLOSION = (SoundEvent)new SoundEvent(new ResourceLocation("aquacreeper", "underwaterexplosion")).setRegistryName("aquacreeper", "underwaterexplosion");
        GameRegistry.register((IForgeRegistryEntry)UNDERWATER_EXPLOSION);
        UNDERWATER_FUSE = (SoundEvent)new SoundEvent(new ResourceLocation("aquacreeper", "underwaterfuse")).setRegistryName("aquacreeper", "underwaterfuse");
        GameRegistry.register((IForgeRegistryEntry)UNDERWATER_FUSE);
        MinecraftForge.EVENT_BUS.register((Object)ConfigHandler.INSTANCE);
    }

    public static int getUniqueEntityId() {
        while (EntityList.func_90035_a((int)(++START_ENTITY_ID)) != null) {
        }
        return START_ENTITY_ID;
    }

    public static void registerEntityEgg(Class<? extends Entity> entity, int baseColor, int spotColor) {
        int id = AquaCreeper.getUniqueEntityId();
        EntityList.func_75618_a(entity, (String)"Aqua Creeper", (int)id);
        EntityList.field_75627_a.put("Aqua Creeper", new EntityList.EntityEggInfo("Aqua Creeper", baseColor, spotColor));
    }

    static {
        START_ENTITY_ID = 1;
    }
}

