/*
 * Decompiled with CFR 0.152.
 */
package aquacreeper.entities;

import aquacreeper.AquaCreeper;
import aquacreeper.network.ParticleMessage;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAquaCreeper
extends EntityMob {
    private static final DataParameter<Integer> INFLATE_SIZE = EntityDataManager.func_187226_a(EntityAquaCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean move = true;

    public EntityAquaCreeper(World world) {
        super(world);
        this.func_70105_a(1.25f, 1.0f);
        this.field_70765_h = new AquaCreeperMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.75, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75, 80));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, false, null));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INFLATE_SIZE, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateSwimmer((EntityLiving)this, world);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 45.0 && this.field_70163_u <= 80.0 && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_184185_a(AquaCreeper.AQUACREEPER_SWIM, 0.5f, 1.0f);
        }
    }

    protected SoundEvent func_184601_bQ() {
        return AquaCreeper.AQUACREEPER_HURT;
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    public boolean func_70686_a(Class entity) {
        return EntityAquaCreeper.class != entity;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void setMove(boolean result) {
        this.move = result;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70171_ac) {
                this.func_70050_g(300);
            } else if (this.field_70122_E) {
                this.field_70181_x += 0.5;
                this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
                this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
                this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
                this.setInflateSize(this.getInflateSize() + 20);
                this.field_70122_E = false;
                this.field_70160_al = true;
            }
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            Double distance;
            if (this.func_70638_az() != null && !this.field_70170_p.func_72953_d(this.func_70638_az().func_174813_aQ()) && (distance = Double.valueOf(this.func_180425_c().func_185332_f((int)this.func_70638_az().field_70165_t, (int)this.func_70638_az().field_70163_u, (int)this.func_70638_az().field_70161_v))) > 1.0 && distance < 6.0 && this.func_70090_H()) {
                double distanceX = this.func_70638_az().field_70165_t - this.field_70165_t;
                double distanceZ = this.func_70638_az().field_70161_v - this.field_70161_v;
                float distanceSqrRoot = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
                this.field_70159_w = distanceX / (double)distanceSqrRoot * 0.5 * 0.900000011920929 + this.field_70159_w * 0.7000000029802322;
                this.field_70179_y = distanceZ / (double)distanceSqrRoot * 0.5 * 0.900000011920929 + this.field_70179_y * 0.7000000029802322;
                this.field_70181_x = 0.4;
            }
            if (this.getInflateSize() <= 0) {
                this.setInflateSize(0);
                this.setMove(true);
            }
            if (this.getInflateSize() > 0) {
                this.setMove(false);
            }
            if (this.getInflateSize() >= 100) {
                this.waterExplosion();
            }
            if (this.func_70638_az() == null && this.func_70090_H()) {
                this.setInflateSize(this.getInflateSize() - 2);
            }
            if (this.func_70638_az() != null && this.func_70090_H()) {
                float distance2 = (float)this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
                if (this.getInflateSize() < 100 && distance2 <= 4.0f) {
                    this.setInflateSize(this.getInflateSize() + 2);
                    this.setMove(false);
                }
                if (this.getInflateSize() < 100 && distance2 > 4.0f) {
                    this.setInflateSize(this.getInflateSize() - 2);
                }
                if (this.getInflateSize() == 2 && distance2 < 4.0f) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, AquaCreeper.UNDERWATER_FUSE, SoundCategory.HOSTILE, 0.5f, 1.0f);
                }
            }
            if (!this.move && this.func_70090_H() && this.field_70181_x < 0.0) {
                this.field_70181_x = 0.0;
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
            double direction = Math.toRadians(this.field_70761_aq);
            this.trailParticles(this.field_70170_p, this.field_70165_t + -Math.sin(direction) * 1.0, this.field_70163_u + 0.75, this.field_70161_v + Math.cos(direction) * 1.0, this.field_70146_Z);
        }
        super.func_70071_h_();
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70613_aW() && this.move) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.1f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.9f;
                this.field_70181_x *= (double)0.9f;
                this.field_70179_y *= (double)0.9f;
                this.field_70181_x -= 0.004;
            } else {
                super.func_70612_e(strafe, forward);
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    private void waterExplosion() {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, AquaCreeper.UNDERWATER_EXPLOSION, SoundCategory.HOSTILE, 1.0f, 1.0f);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, true);
        this.waterExplosionParticles((float)this.field_70165_t + 0.5f, (float)this.field_70163_u + 0.5f, (float)this.field_70161_v + 0.5f);
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public void trailParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 5; ++count) {
            double velX = 0.0;
            double velY = 0.0;
            double velZ = 0.0;
            int motionX = rand.nextInt(2) * 2;
            int motionZ = rand.nextInt(2) * 2;
            velY = ((double)rand.nextFloat() - 0.5) * 0.125;
            velZ = rand.nextFloat() * 1.0f * (float)motionZ;
            velX = rand.nextFloat() * 1.0f * (float)motionX;
            AquaCreeper.PROXY.spawnCustomParticle("bubbles", this.field_70170_p, x, y, z, velX, velY, velZ);
        }
    }

    private void waterExplosionParticles(float x, float y, float z) {
        for (EntityPlayer playersNear : this.field_70170_p.field_73010_i) {
            if (!(playersNear.func_70068_e((Entity)this) < 256.0)) continue;
            AquaCreeper.NETWORK_WRAPPER.sendToAll((IMessage)new ParticleMessage(x, y, z));
        }
    }

    public void setInflateSize(int size) {
        this.field_70180_af.func_187227_b(INFLATE_SIZE, (Object)size);
    }

    public int getInflateSize() {
        return (Integer)this.field_70180_af.func_187225_a(INFLATE_SIZE);
    }

    static class AquaCreeperMoveHelper
    extends EntityMoveHelper {
        private final EntityAquaCreeper aquaCreeper;

        public AquaCreeperMoveHelper(EntityAquaCreeper aquaCreeper) {
            super((EntityLiving)aquaCreeper);
            this.aquaCreeper = aquaCreeper;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.aquaCreeper.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.aquaCreeper.field_70165_t;
                double d1 = this.field_75647_c - this.aquaCreeper.field_70163_u;
                double d2 = this.field_75644_d - this.aquaCreeper.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.aquaCreeper.field_70761_aq = this.aquaCreeper.field_70177_z = this.func_75639_a(this.aquaCreeper.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.aquaCreeper.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.aquaCreeper.func_70659_e(this.aquaCreeper.func_70689_ay() + (f1 - this.aquaCreeper.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.aquaCreeper.field_70173_aa + this.aquaCreeper.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.aquaCreeper.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.aquaCreeper.field_70177_z * ((float)Math.PI / 180));
                this.aquaCreeper.field_70159_w += d4 * d5;
                this.aquaCreeper.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.aquaCreeper.field_70173_aa + this.aquaCreeper.func_145782_y()) * 0.75) * 0.05;
                this.aquaCreeper.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.aquaCreeper.field_70181_x += (double)this.aquaCreeper.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.aquaCreeper.func_70671_ap();
                double d7 = this.aquaCreeper.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.aquaCreeper.func_70047_e() + this.aquaCreeper.field_70163_u + d1 / d3;
                double d9 = this.aquaCreeper.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.aquaCreeper.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
            } else {
                this.aquaCreeper.func_70659_e(0.0f);
            }
        }
    }
}

