/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering.model;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuadCaching;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.client.rendering.model.ICustomCachedCreativeRendered;
import com.creativemd.creativecore.client.rendering.model.IExtendedCreativeRendered;
import com.creativemd.creativecore.common.block.TileEntityState;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CreativeBakedModel
implements IBakedModel,
IPerspectiveAwareModel {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static TextureAtlasSprite woodenTexture;
    private static ItemStack lastItemStack;
    public static ItemOverrideList customOverride;
    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms;
    private static TRSRTransformation baseState;
    private static final TRSRTransformation flipX;

    public static void setLastItemStack(ItemStack stack) {
        lastItemStack = stack;
    }

    public static TextureAtlasSprite getWoodenTexture() {
        if (woodenTexture == null) {
            woodenTexture = mc.func_147117_R().func_110572_b("minecraft:blocks/planks_oak");
        }
        return woodenTexture;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return CreativeBakedModel.getBlockQuads(state, side, rand, false);
    }

    public static boolean doesBlockHaveColor(Block block) {
        if (block.func_180664_k() == BlockRenderLayer.CUTOUT_MIPPED) {
            return true;
        }
        Map blockColorMap = (Map)ReflectionHelper.getPrivateValue(BlockColors.class, (Object)mc.func_184125_al(), (String[])new String[]{"blockColorMap"});
        return blockColorMap.containsKey(block.delegate);
    }

    public static List<BakedQuad> getBlockQuads(List<RenderCubeObject> cubes, List<BakedQuad> baked, ICreativeRendered renderer, EnumFacing side, IBlockState state, BlockRenderLayer layer, Block renderBlock, TileEntity te, long rand, ItemStack stack, boolean threaded) {
        for (int i = 0; i < cubes.size(); ++i) {
            IBlockState newState;
            RenderCubeObject cube;
            block12: {
                cube = cubes.get(i);
                if (!cube.shouldSideBeRendered(side)) continue;
                Block block = renderBlock;
                if (cube.block != null) {
                    block = cube.block;
                }
                newState = cube.getBlockState(block);
                if (state != null && te != null) {
                    newState = newState.func_185899_b((IBlockAccess)te.func_145831_w(), te.func_174877_v());
                }
                try {
                    if (layer != null && renderBlock != null && !renderBlock.canRenderInLayer(state, layer)) {
                    }
                    break block12;
                }
                catch (Exception e) {
                    try {
                        if (block.func_180664_k() != layer) {
                            continue;
                        }
                        break block12;
                    }
                    catch (Exception e2) {
                        if (layer == BlockRenderLayer.SOLID) break block12;
                    }
                }
                continue;
            }
            IBakedModel blockModel = mc.func_175602_ab().func_184389_a(newState);
            CubeObject uvCube = cube.offset(cube.getOffset());
            baked.addAll(CreativeBakedModel.getBakedQuad(cube, uvCube, newState, blockModel, side, rand));
        }
        if (renderer instanceof ICustomCachedCreativeRendered && !FMLClientHandler.instance().hasOptifine() && stack == null) {
            CreativeBakedQuadCaching caching = new CreativeBakedQuadCaching(baked, side, (ICustomCachedCreativeRendered)renderer, te, stack, layer);
            baked = new ArrayList<BakedQuad>();
            if (caching.quads.size() > 0) {
                baked.add(caching);
            }
        }
        if (baked.size() > 0) {
            renderer.saveCachedModel(side, layer, baked, state, te, stack, threaded);
        }
        return baked;
    }

    public static List<BakedQuad> getBakedQuad(RenderCubeObject cube, CubeObject uvCube, IBlockState state, IBakedModel blockModel, EnumFacing side, long rand) {
        return CreativeBakedModel.getBakedQuad(cube, uvCube, state, blockModel, side, rand, true);
    }

    public static List<BakedQuad> getBakedQuad(RenderCubeObject cube, CubeObject uvCube, IBlockState state, IBakedModel blockModel, EnumFacing side, long rand, boolean overrideTint) {
        List blockQuads = blockModel.func_188616_a(state, side, rand);
        if (blockQuads.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (int i = 0; i < blockQuads.size(); ++i) {
            CreativeBakedQuad quad = new CreativeBakedQuad((BakedQuad)blockQuads.get(i), cube, cube.color, overrideTint && cube.color != -1, side);
            EnumFacing facing = side;
            EnumFaceDirection direction = EnumFaceDirection.func_179027_a((EnumFacing)facing);
            for (int k = 0; k < 4; ++k) {
                EnumFaceDirection.VertexInformation vertex = direction.func_179025_a(k);
                int index = k * quad.getFormat().func_181719_f();
                float newX = cube.getVertexInformationPosition(vertex.field_179184_a);
                float newY = cube.getVertexInformationPosition(vertex.field_179182_b);
                float newZ = cube.getVertexInformationPosition(vertex.field_179183_c);
                quad.func_178209_a()[index] = Float.floatToIntBits(newX);
                quad.func_178209_a()[index + 1] = Float.floatToIntBits(newY);
                quad.func_178209_a()[index + 2] = Float.floatToIntBits(newZ);
                if (cube.keepVU) continue;
                int uvIndex = index + quad.getFormat().func_177344_b(0) / 4;
                newX = uvCube.getVertexInformationPosition(vertex.field_179184_a);
                newY = uvCube.getVertexInformationPosition(vertex.field_179182_b);
                newZ = uvCube.getVertexInformationPosition(vertex.field_179183_c);
                float u = 0.0f;
                float v = 0.0f;
                switch (facing) {
                    case EAST: {
                        newY = 1.0f - newY;
                        newZ = 1.0f - newZ;
                    }
                    case WEST: {
                        if (facing == EnumFacing.WEST) {
                            newY = 1.0f - newY;
                        }
                        u = newZ;
                        v = newY;
                        break;
                    }
                    case DOWN: {
                        newZ = 1.0f - newZ;
                    }
                    case UP: {
                        u = newX;
                        v = newZ;
                        break;
                    }
                    case NORTH: {
                        newY = 1.0f - newY;
                        newX = 1.0f - newX;
                    }
                    case SOUTH: {
                        if (facing == EnumFacing.SOUTH) {
                            newY = 1.0f - newY;
                        }
                        u = newX;
                        v = newY;
                    }
                }
                quad.func_178209_a()[uvIndex] = Float.floatToRawIntBits(quad.func_187508_a().func_94214_a((double)(u *= 16.0f)));
                quad.func_178209_a()[uvIndex + 1] = Float.floatToRawIntBits(quad.func_187508_a().func_94207_b((double)(v *= 16.0f)));
            }
            quads.add(quad);
        }
        return quads;
    }

    public static List<BakedQuad> getBlockQuads(IBlockState state, EnumFacing side, long rand, boolean threaded) {
        ArrayList<BakedQuad> baked = new ArrayList<BakedQuad>();
        Block renderBlock = null;
        if (state == null && lastItemStack != null) {
            renderBlock = Block.func_149634_a((Item)lastItemStack.func_77973_b());
        } else if (state != null) {
            renderBlock = state.func_177230_c();
        }
        TileEntity te = state instanceof TileEntityState ? ((TileEntityState)state).te : null;
        ItemStack stack = state != null ? null : lastItemStack;
        List<RenderCubeObject> cubes = null;
        ICreativeRendered renderer = null;
        if (renderBlock instanceof ICreativeRendered) {
            renderer = (ICreativeRendered)renderBlock;
        } else if (lastItemStack != null && lastItemStack.func_77973_b() instanceof ICreativeRendered) {
            renderer = (ICreativeRendered)lastItemStack.func_77973_b();
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (renderer instanceof IExtendedCreativeRendered) {
            baked.addAll(((IExtendedCreativeRendered)renderer).getSpecialBakedQuads(state, te, side, rand, stack));
        }
        if (side == null) {
            return baked;
        }
        if (renderer != null) {
            List<BakedQuad> cached = renderer.getCachedModel(side, layer, state, te, stack, threaded);
            if (cached != null) {
                return cached;
            }
            cubes = renderer.getRenderingCubes(state, te, stack);
        }
        if (cubes != null) {
            return CreativeBakedModel.getBlockQuads(cubes, baked, renderer, side, state, layer, renderBlock, te, rand, stack, threaded);
        }
        return baked;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return CreativeBakedModel.getWoodenTexture();
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    private static TRSRTransformation leftify(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    public static final void loadTransformation() {
        TRSRTransformation thirdperson = CreativeBakedModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)CreativeBakedModel.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)CreativeBakedModel.get(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)CreativeBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)CreativeBakedModel.leftify(thirdperson));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)CreativeBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)CreativeBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        SimpleModelState perState = new SimpleModelState(ImmutableMap.copyOf((Map)builder.build()));
        baseState = (TRSRTransformation)perState.apply(Optional.absent()).or((Object)TRSRTransformation.identity());
        cameraTransforms = ImmutableMap.copyOf((Map)builder.build());
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (cameraTransforms == null) {
            CreativeBakedModel.loadTransformation();
        }
        if (lastItemStack != null) {
            ICreativeRendered renderer = null;
            Block block = Block.func_149634_a((Item)lastItemStack.func_77973_b());
            if (block instanceof ICreativeRendered) {
                renderer = (ICreativeRendered)block;
            } else if (lastItemStack != null && lastItemStack.func_77973_b() instanceof ICreativeRendered) {
                renderer = (ICreativeRendered)lastItemStack.func_77973_b();
            }
            if (renderer != null) {
                renderer.applyCustomOpenGLHackery(lastItemStack, cameraTransformType);
            }
        }
        TRSRTransformation tr = (TRSRTransformation)cameraTransforms.get((Object)cameraTransformType);
        Matrix4f mat = null;
        if (tr != null && !tr.equals((Object)TRSRTransformation.identity())) {
            mat = TRSRTransformation.blockCornerToCenter((TRSRTransformation)tr).getMatrix();
        }
        return Pair.of((Object)this, mat);
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return customOverride;
    }

    static {
        lastItemStack = null;
        customOverride = new ItemOverrideList(new ArrayList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                lastItemStack = stack;
                return super.handleItemState(originalModel, stack, world, entity);
            }
        };
        flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    }
}

