/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering.model;

import com.creativemd.creativecore.client.rendering.model.QuadCache;
import java.lang.reflect.Field;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CreativeConsumer
extends VertexLighterSmoothAo {
    public static CreativeConsumer instance = new CreativeConsumer(Minecraft.func_71410_x().func_184125_al());
    private static Field tint = ReflectionHelper.findField(VertexLighterFlat.class, (String[])new String[]{"tint"});
    private static Field diffuse = ReflectionHelper.findField(VertexLighterFlat.class, (String[])new String[]{"diffuse"});
    private static Field renderer = ReflectionHelper.findField(VertexBufferConsumer.class, (String[])new String[]{"renderer"});
    private static Field offset = ReflectionHelper.findField(VertexBufferConsumer.class, (String[])new String[]{"offset"});
    public BlockInfo blockInfo;
    public boolean shouldOverrideColor = false;
    public IBlockState state;
    public QuadCache lastCache = null;

    public CreativeConsumer(BlockColors colors) {
        super(colors);
    }

    public IVertexConsumer getParent() {
        return this.parent;
    }

    public static void processCachedQuad(IVertexConsumer parent, QuadCache[] cached) {
        try {
            BlockPos pos = (BlockPos)offset.get(parent);
            VertexBuffer buffer = (VertexBuffer)renderer.get(parent);
            for (int i = 0; i < cached.length; ++i) {
                for (int j = 0; j < cached[i].quadDatas.size(); ++j) {
                    buffer.func_178981_a(cached[i].quadDatas.get(j));
                    buffer.func_178987_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
        lightmap[0] = this.calcLightmap(this.blockInfo.getBlockLight(), x, y, z);
        lightmap[1] = this.calcLightmap(this.blockInfo.getSkyLight(), x, y, z);
    }

    protected float getAo(float x, float y, float z) {
        int sz;
        int sx = x < 0.0f ? 1 : 2;
        int sy = y < 0.0f ? 1 : 2;
        int n = sz = z < 0.0f ? 1 : 2;
        if (x < 0.0f) {
            x += 1.0f;
        }
        if (y < 0.0f) {
            y += 1.0f;
        }
        if (z < 0.0f) {
            z += 1.0f;
        }
        float a = 0.0f;
        float[][][] ao = this.blockInfo.getAo();
        a += ao[sx - 1][sy - 1][sz - 1] * (1.0f - x) * (1.0f - y) * (1.0f - z);
        a += ao[sx - 1][sy - 1][sz - 0] * (1.0f - x) * (1.0f - y) * (0.0f + z);
        a += ao[sx - 1][sy - 0][sz - 1] * (1.0f - x) * (0.0f + y) * (1.0f - z);
        a += ao[sx - 1][sy - 0][sz - 0] * (1.0f - x) * (0.0f + y) * (0.0f + z);
        a += ao[sx - 0][sy - 1][sz - 1] * (0.0f + x) * (1.0f - y) * (1.0f - z);
        a += ao[sx - 0][sy - 1][sz - 0] * (0.0f + x) * (1.0f - y) * (0.0f + z);
        a += ao[sx - 0][sy - 0][sz - 1] * (0.0f + x) * (0.0f + y) * (1.0f - z);
        a += ao[sx - 0][sy - 0][sz - 0] * (0.0f + x) * (0.0f + y) * (0.0f + z);
        a = MathHelper.func_76131_a((float)a, (float)0.0f, (float)1.0f);
        return a;
    }

    public void updateBlockInfo() {
        this.blockInfo.updateShift(false);
        this.blockInfo.updateLightMatrix();
    }

    protected void processQuad() {
        float[][] position = this.quadData[this.posIndex];
        float[][] normal = null;
        float[][] lightmap = this.quadData[this.lightmapIndex];
        float[][] color = this.quadData[this.colorIndex];
        if (this.normalIndex != -1 && (this.quadData[this.normalIndex][0][0] != -1.0f || this.quadData[this.normalIndex][0][1] != -1.0f || this.quadData[this.normalIndex][0][2] != -1.0f)) {
            normal = this.quadData[this.normalIndex];
        } else {
            normal = new float[4][4];
            Vector3f v1 = new Vector3f(position[3]);
            Vector3f t = new Vector3f(position[1]);
            Vector3f v2 = new Vector3f(position[2]);
            v1.sub((Tuple3f)t);
            t.set(position[0]);
            v2.sub((Tuple3f)t);
            v1.cross(v2, v1);
            v1.normalize();
            for (int v = 0; v < 4; ++v) {
                normal[v][0] = v1.x;
                normal[v][1] = v1.y;
                normal[v][2] = v1.z;
                normal[v][3] = 0.0f;
            }
        }
        int multiplier = -1;
        int parentTint = -1;
        try {
            parentTint = tint.getInt((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException e2) {
            e2.printStackTrace();
        }
        multiplier = parentTint != -1 && !this.shouldOverrideColor ? Minecraft.func_71410_x().func_184125_al().func_186724_a(this.state, this.blockInfo.getWorld(), this.blockInfo.getBlockPos(), parentTint) : parentTint;
        VertexFormat format = this.parent.getVertexFormat();
        int count = format.func_177345_h();
        boolean diffuseCache = false;
        try {
            diffuseCache = diffuse.getBoolean((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException e2) {
            e2.printStackTrace();
        }
        QuadCache cache = new QuadCache(format);
        for (int v = 0; v < 4; ++v) {
            float[] fArray = position[v];
            fArray[0] = fArray[0] + this.blockInfo.getShx();
            float[] fArray2 = position[v];
            fArray2[1] = fArray2[1] + this.blockInfo.getShy();
            float[] fArray3 = position[v];
            fArray3[2] = fArray3[2] + this.blockInfo.getShz();
            float x = position[v][0] - 0.5f;
            float y = position[v][1] - 0.5f;
            float z = position[v][2] - 0.5f;
            float blockLight = lightmap[v][0];
            float skyLight = lightmap[v][1];
            this.updateLightmap(normal[v], lightmap[v], x += normal[v][0] * 0.5f, y += normal[v][1] * 0.5f, z += normal[v][2] * 0.5f);
            if (this.dataLength[this.lightmapIndex] > 1) {
                if (blockLight > lightmap[v][0]) {
                    lightmap[v][0] = blockLight;
                }
                if (skyLight > lightmap[v][1]) {
                    lightmap[v][1] = skyLight;
                }
            }
            this.updateColor(normal[v], color[v], x, y, z, parentTint, multiplier);
            if (diffuseCache) {
                float d = LightUtil.diffuseLight((float)normal[v][0], (float)normal[v][1], (float)normal[v][2]);
                int i = 0;
                while (i < 3) {
                    float[] fArray4 = color[v];
                    int n = i++;
                    fArray4[n] = fArray4[n] * d;
                }
            }
            if (EntityRenderer.field_78517_a) {
                this.applyAnaglyph(color[v]);
            }
            block13: for (int e = 0; e < count; ++e) {
                VertexFormatElement element = format.func_177348_c(e);
                switch (element.func_177375_c()) {
                    case POSITION: {
                        cache.addCache(e, position[v]);
                        this.parent.put(e, position[v]);
                        continue block13;
                    }
                    case NORMAL: {
                        if (this.normalIndex != -1) {
                            cache.addCache(e, normal[v]);
                            this.parent.put(e, normal[v]);
                            continue block13;
                        }
                    }
                    case COLOR: {
                        cache.addCache(e, color[v]);
                        this.parent.put(e, color[v]);
                        continue block13;
                    }
                    case UV: {
                        if (element.func_177369_e() == 1) {
                            cache.addCache(e, lightmap[v]);
                            this.parent.put(e, lightmap[v]);
                            continue block13;
                        }
                    }
                    default: {
                        cache.addCache(e, this.quadData[e][v]);
                        this.parent.put(e, this.quadData[e][v]);
                    }
                }
            }
        }
        this.lastCache = cache;
        this.setQuadTint(-1);
    }
}

