/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils;

import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.util.Color;

public class ColorUtils {
    public static int WHITE = 0xFFFFFF;

    public static int RGBAToInt(Color color) {
        return (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
    }

    public static Color IntToRGBA(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return new Color(r, g, b, a);
    }

    public static int RGBToInt(Vec3i color) {
        return (color.func_177958_n() & 0xFF) << 16 | (color.func_177956_o() & 0xFF) << 8 | color.func_177952_p() & 0xFF;
    }

    public static Vec3i IntToRGB(int color) {
        float r = color >> 16 & 0xFF;
        float g = color >> 8 & 0xFF;
        float b = color & 0xFF;
        return new Vec3i((double)r, (double)g, (double)b);
    }

    public static Vec3d IntToVec(int color) {
        float r = color >> 16 & 0xFF;
        float g = color >> 8 & 0xFF;
        float b = color & 0xFF;
        return new Vec3d((double)(r / 255.0f), (double)(g / 255.0f), (double)(b / 255.0f));
    }

    public static int VecToInt(Vec3d color) {
        return ColorUtils.RGBToInt(new Vec3i(color.field_72450_a * 255.0, color.field_72448_b * 255.0, color.field_72449_c * 255.0));
    }

    public static Vec3i colorToVec(Color color) {
        return new Vec3i(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static enum ColorPart {
        RED{

            @Override
            public int getColor(Color color) {
                return color.getRed();
            }

            @Override
            public void setColor(Color color, int intenstiy) {
                color.setRed(intenstiy);
            }

            @Override
            public int getBrightest() {
                return 0xFF0000;
            }
        }
        ,
        GREEN{

            @Override
            public int getColor(Color color) {
                return color.getGreen();
            }

            @Override
            public void setColor(Color color, int intenstiy) {
                color.setGreen(intenstiy);
            }

            @Override
            public int getBrightest() {
                return 65280;
            }
        }
        ,
        BLUE{

            @Override
            public int getColor(Color color) {
                return color.getBlue();
            }

            @Override
            public void setColor(Color color, int intenstiy) {
                color.setBlue(intenstiy);
            }

            @Override
            public int getBrightest() {
                return 255;
            }
        }
        ,
        ALPHA{

            @Override
            public int getColor(Color color) {
                return color.getAlpha();
            }

            @Override
            public void setColor(Color color, int intenstiy) {
                color.setAlpha(intenstiy);
            }

            @Override
            public int getBrightest() {
                return 255;
            }
        };


        public abstract int getColor(Color var1);

        public abstract void setColor(Color var1, int var2);

        public abstract int getBrightest();
    }
}

