/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils;

import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.common.utils.RotationUtils;
import java.util.ArrayList;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class CubeObject {
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    public CubeObject(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public CubeObject(AxisAlignedBB box) {
        this((float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72339_c, (float)box.field_72336_d, (float)box.field_72337_e, (float)box.field_72334_f);
    }

    public CubeObject() {
        this(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public CubeObject(CubeObject cube) {
        this(cube.minX, cube.minY, cube.minZ, cube.maxX, cube.maxY, cube.maxZ, cube);
    }

    public CubeObject(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, CubeObject cube) {
        this(minX, minY, minZ, maxX, maxY, maxZ);
        this.applyExtraCubeData(cube);
    }

    protected void applyExtraCubeData(CubeObject cube) {
    }

    public void add(Vec3d vec) {
        this.minX = (float)((double)this.minX + vec.field_72450_a);
        this.minY = (float)((double)this.minY + vec.field_72448_b);
        this.minZ = (float)((double)this.minZ + vec.field_72449_c);
        this.maxX = (float)((double)this.maxX + vec.field_72450_a);
        this.maxY = (float)((double)this.maxY + vec.field_72448_b);
        this.maxZ = (float)((double)this.maxZ + vec.field_72449_c);
    }

    public void sub(Vec3d vec) {
        this.minX = (float)((double)this.minX - vec.field_72450_a);
        this.minY = (float)((double)this.minY - vec.field_72448_b);
        this.minZ = (float)((double)this.minZ - vec.field_72449_c);
        this.maxX = (float)((double)this.maxX - vec.field_72450_a);
        this.maxY = (float)((double)this.maxY - vec.field_72448_b);
        this.maxZ = (float)((double)this.maxZ - vec.field_72449_c);
    }

    public Vec3d getSize() {
        return new Vec3d((double)(this.maxX - this.minX), (double)(this.maxY - this.minY), (double)(this.maxZ - this.minZ));
    }

    public String toString() {
        return "cube[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public AxisAlignedBB getAxis() {
        return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public static Vec3d getSizeOfCubes(ArrayList<? extends CubeObject> cubes) {
        if (cubes.size() == 0) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        CubeObject cube = new CubeObject(cubes.get(0));
        for (int i = 1; i < cubes.size(); ++i) {
            cube.minX = Math.min(cube.minX, cubes.get((int)i).minX);
            cube.minY = Math.min(cube.minY, cubes.get((int)i).minY);
            cube.minZ = Math.min(cube.minZ, cubes.get((int)i).minZ);
            cube.maxX = Math.max(cube.maxX, cubes.get((int)i).maxX);
            cube.maxY = Math.max(cube.maxY, cubes.get((int)i).maxY);
            cube.maxZ = Math.max(cube.maxZ, cubes.get((int)i).maxZ);
        }
        return cube.getSize();
    }

    public static Vec3d getBigestCubeSize(ArrayList<CubeObject> cubes) {
        Vec3d size = null;
        for (int i = 0; i < cubes.size(); ++i) {
            Vec3d newSize = cubes.get(i).getSize();
            size = size == null ? newSize : new Vec3d(Math.max(size.field_72450_a, newSize.field_72450_a), Math.max(size.field_72448_b, newSize.field_72448_b), Math.max(size.field_72449_c, newSize.field_72449_c));
        }
        return size;
    }

    public void rotate(EnumFacing facing, Vector3f center) {
        Matrix3f matrix = new Matrix3f();
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            facing = facing.func_176734_d();
        }
        matrix.rotY((float)Math.toRadians(facing.func_185119_l()));
        this.rotate(matrix, center);
    }

    public void rotate(Matrix3f matrix, Vector3f center) {
        Vector3f low = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f high = new Vector3f(this.maxX, this.maxY, this.maxZ);
        low.sub((Tuple3f)center);
        high.sub((Tuple3f)center);
        matrix.transform((Tuple3f)low);
        matrix.transform((Tuple3f)high);
        low.add((Tuple3f)center);
        high.add((Tuple3f)center);
        this.set(low.x, low.y, low.z, high.x, high.y, high.z);
    }

    public void set(float x, float y, float z, float x2, float y2, float z2) {
        this.minX = Math.min(x, x2);
        this.minY = Math.min(y, y2);
        this.minZ = Math.min(z, z2);
        this.maxX = Math.max(x, x2);
        this.maxY = Math.max(y, y2);
        this.maxZ = Math.max(z, z2);
    }

    public BlockPos getOffset() {
        return new BlockPos((double)this.minX, (double)this.minY, (double)this.minZ);
    }

    public CubeObject offset(BlockPos pos) {
        return new CubeObject(this.minX - (float)pos.func_177958_n(), this.minY - (float)pos.func_177956_o(), this.minZ - (float)pos.func_177952_p(), this.maxX - (float)pos.func_177958_n(), this.maxY - (float)pos.func_177956_o(), this.maxZ - (float)pos.func_177952_p(), this);
    }

    public static CubeObject rotateCube(CubeObject cube, EnumFacing direction) {
        return CubeObject.rotateCube(cube, direction, new Vec3d(0.5, 0.5, 0.5));
    }

    public static CubeObject rotateCube(CubeObject cube, EnumFacing direction, Vec3d center) {
        return CubeObject.rotateCube(cube, Rotation.getRotationByFacing(direction), center);
    }

    public static CubeObject rotateCube(CubeObject cube, Rotation direction, Vec3d center) {
        CubeObject rotateCube = new CubeObject(cube);
        RotationUtils.applyCubeRotation(rotateCube, direction, center);
        return rotateCube;
    }

    public float getVertexInformationPositionOposite(int index) {
        switch (EnumFacing.func_82600_a((int)index).func_176734_d()) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public float getVertexInformationPosition(int index) {
        switch (EnumFacing.func_82600_a((int)index)) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public CubeObject flip(EnumFacing facing) {
        CubeObject cube = new CubeObject(this);
        switch (facing) {
            case EAST: 
            case WEST: {
                cube.maxX = 1.0f - this.minX;
                cube.minX = 1.0f - this.maxX;
                break;
            }
            case UP: 
            case DOWN: {
                cube.maxY = 1.0f - this.minY;
                cube.minY = 1.0f - this.maxY;
                break;
            }
            case SOUTH: 
            case NORTH: {
                cube.maxZ = 1.0f - this.minZ;
                cube.minZ = 1.0f - this.maxZ;
            }
        }
        return cube;
    }
}

