/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui;

import com.creativemd.creativecore.common.utils.ColorUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Color;

@SideOnly(value=Side.CLIENT)
public class GuiRenderHelper {
    public static GuiRenderHelper instance = new GuiRenderHelper(Minecraft.func_71410_x());
    public FontRenderer font;
    public RenderItem itemRenderer;
    public static Minecraft mc = Minecraft.func_71410_x();

    public GuiRenderHelper(Minecraft mc) {
        this(mc.field_71466_p, mc.func_175599_af());
    }

    public GuiRenderHelper(FontRenderer font, RenderItem itemRenderer) {
        this.font = font;
        this.itemRenderer = itemRenderer;
    }

    public void drawHorizontalChannelMaskGradientRect(int left, int top, int right, int bottom, int colour, int mask) {
        this.drawHorizontalGradientRect(left, top, right, bottom, colour & ~mask | 0xFF000000, colour | 0xFF000000 | mask);
    }

    public void drawHorizontalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public void renderColorPlate(Color color, int width, int height) {
        this.renderColorPlate(0, 0, color, width, height);
    }

    public void renderColorPlate(int x, int y, Color color, int width, int height) {
        Gui.func_73734_a((int)x, (int)y, (int)width, (int)height, (int)ColorUtils.RGBAToInt(color));
    }

    public static void renderColorTriangle(int x1, int y1, int x2, int y2, int x3, int y3, Color color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        vertexbuffer.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)y3, (double)y3, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderBakedQuads(List<BakedQuad> baked) {
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (int i = 0; i < baked.size(); ++i) {
            int tint = baked.get(i).func_178211_c();
            if (tint == 0) {
                tint = -1;
            }
            LightUtil.renderQuadColor((VertexBuffer)vertexbuffer, (BakedQuad)baked.get(i), (int)tint);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    public int getFontHeight() {
        return this.font.field_78288_b;
    }

    public int getStringWidth(String text) {
        return this.font.func_78256_a(text);
    }

    public int drawStringWithShadow(String text, int width, int height, int color) {
        return this.drawStringWithShadow(text, 0, 0, width, height, color);
    }

    public int drawStringWithShadow(String text, int x, int y, int width, int height, int color) {
        return this.drawStringWithShadow(text, x, y, width, height, color, 0);
    }

    public int drawStringWithShadow(String text, int x, int y, int width, int height, int color, int additionalWidth) {
        int completeWidth = this.font.func_78256_a(text) + additionalWidth;
        this.font.func_175063_a(text, (float)(width / 2 - completeWidth / 2 + additionalWidth), (float)(height / 2 - this.getFontHeight() / 2), color);
        return completeWidth;
    }

    public void drawItemStackAndOverlay(ItemStack stack, int x, int y, int width, int height) {
        this.drawItemStack(stack, x, y, width, height);
        GlStateManager.func_179094_E();
        if (String.valueOf(stack.field_77994_a).length() > 3) {
            String s = String.valueOf(stack.field_77994_a);
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            int fontWidth = this.font.func_78256_a(s);
            GlStateManager.func_179109_b((float)(this.font.field_78288_b / 2), (float)(fontWidth / 2), (float)0.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179109_b((float)(-this.font.field_78288_b / 2), (float)(-fontWidth / 2), (float)0.0f);
            this.font.func_175063_a(s, (float)(x + 19 - 2 - (fontWidth /= 2)), (float)(y + 6 + 5), 0xFFFFFF);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            this.itemRenderer.func_180453_a(this.font, stack, x, y, "");
        } else {
            this.itemRenderer.func_175030_a(this.font, stack, x, y);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
    }

    public void drawItemStack(ItemStack stack, int x, int y, int width, int height) {
        this.drawItemStack(stack, x, y, width, height, 0);
    }

    public void drawItemStack(ItemStack stack, int x, int y, int width, int height, int rotation) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)(x + 8), (float)(y + 8), (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)((double)width / 16.0), (double)((double)height / 16.0), (double)1.0);
        GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)(-this.itemRenderer.field_77023_b - 50.0f));
        GlStateManager.func_179126_j();
        this.itemRenderer.func_180450_b(stack, 0, 0);
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
    }
}

