/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.container;

import com.creativemd.creativecore.gui.CoreControl;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.GuiRenderHelper;
import com.creativemd.creativecore.gui.Rect;
import com.creativemd.creativecore.gui.client.style.Style;
import com.creativemd.creativecore.gui.container.IControlParent;
import com.creativemd.creativecore.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.gui.event.gui.GuiToolTipEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiParent
extends GuiControl
implements IControlParent {
    public ArrayList<GuiControl> controls = new ArrayList();
    protected int lastRenderedHeight = 0;

    public GuiParent(String name, int x, int y, int width, int height) {
        super(name, x, y, width, height);
    }

    @Override
    public List getControls() {
        return this.controls;
    }

    @Override
    public void refreshControls() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.updateControl(this.controls.get(i), i);
        }
    }

    public void updateControl(GuiControl control, int id) {
        control.parent = this;
        control.setID(id);
    }

    public void addControl(GuiControl control) {
        this.updateControl(control, this.controls.size());
        this.controls.add(control);
    }

    public float getScaleFactor() {
        return 1.0f;
    }

    protected int getOffsetY() {
        return 0;
    }

    protected int getOffsetX() {
        return 0;
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height, Rect relativeMaximumRect) {
        float scale = this.getScaleFactor();
        int xOffset = this.getOffsetX();
        int yOffset = this.getOffsetY();
        Rect newRect = relativeMaximumRect.mergeRects(this.getRect());
        this.lastRenderedHeight = 0;
        for (int i = this.controls.size() - 1; i >= 0; --i) {
            GuiControl control = this.controls.get(i);
            if (control.visible && control.isVisibleInsideRect(-xOffset, -yOffset, width, height, scale)) {
                GL11.glEnable((int)2960);
                this.prepareContentStencil(helper, relativeMaximumRect);
                GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                GL11.glStencilFunc((int)514, (int)1, (int)1);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)xOffset, (float)yOffset, (float)0.0f);
                control.renderControl(helper, scale, newRect.getOffsetRect(xOffset, yOffset));
                GlStateManager.func_179121_F();
                GL11.glDisable((int)2960);
            }
            this.lastRenderedHeight = (int)Math.max((float)this.lastRenderedHeight, (float)(control.posY + control.height) * scale);
        }
        GL11.glEnable((int)2960);
        this.prepareContentStencil(helper, relativeMaximumRect);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilFunc((int)514, (int)1, (int)1);
        this.renderContent(helper, style, width, height);
        GL11.glDisable((int)2960);
    }

    @Override
    public CoreControl get(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            CoreControl tempcontrol;
            GuiControl control = this.controls.get(i);
            if (control.is(name)) {
                return control;
            }
            if (!(control instanceof IControlParent) || (tempcontrol = ((IControlParent)((Object)control)).get(name)) == null) continue;
            return tempcontrol;
        }
        return null;
    }

    @Override
    public boolean has(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver() {
        if (this.parent != null) {
            return super.isMouseOver();
        }
        return true;
    }

    @Override
    public Vec3d getMousePos() {
        if (this.parent != null) {
            return this.getParent().getMousePos().func_72441_c((double)(-this.getOffsetX() - this.posX), (double)(-this.getOffsetY() - this.posY), 0.0);
        }
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        int x = Mouse.getEventX() * i / GuiParent.mc.field_71443_c;
        int y = j - Mouse.getEventY() * j / GuiParent.mc.field_71440_d - 1;
        int movex = (i - this.width) / 2;
        int movey = (j - this.height) / 2;
        return new Vec3d((double)((x -= movex) - this.getContentOffset() - this.getOffsetX()), (double)((y -= movey) - this.getContentOffset() - this.getOffsetY()), 0.0);
    }

    @Override
    public void onOpened() {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            control.parent = this;
            control.onOpened();
        }
        this.refreshControls();
    }

    @Override
    public void onClosed() {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            control.onClosed();
        }
    }

    @Override
    public void onTick() {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            control.onTick();
        }
    }

    @Override
    public void onLoseFocus() {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            control.onLoseFocus();
        }
    }

    @Override
    public boolean mouseScrolled(int x, int y, int scrolled) {
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!control.isInteractable() || !control.isMouseOver((int)pos.field_72450_a, (int)pos.field_72448_b) || !control.mouseScrolled((int)pos.field_72450_a, (int)pos.field_72448_b, scrolled)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mousePressed(int x, int y, int button) {
        boolean result = false;
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!result && control.isInteractable() && control.isMouseOver((int)pos.field_72450_a, (int)pos.field_72448_b) && control.mousePressed((int)pos.field_72450_a, (int)pos.field_72448_b, button)) {
                this.raiseEvent(new GuiControlClickEvent(control, x, y));
                result = true;
                continue;
            }
            control.onLoseFocus();
        }
        return result;
    }

    @Override
    public void mouseMove(int x, int y, int button) {
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!control.isInteractable()) continue;
            control.mouseMove((int)pos.field_72450_a, (int)pos.field_72448_b, button);
        }
    }

    @Override
    public void mouseReleased(int x, int y, int button) {
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!control.isInteractable()) continue;
            control.mouseReleased((int)pos.field_72450_a, (int)pos.field_72448_b, button);
        }
    }

    @Override
    public boolean onKeyPressed(char character, int key) {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable() || !control.onKeyPressed(character, key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GuiToolTipEvent getToolTipEvent() {
        GuiToolTipEvent event = super.getToolTipEvent();
        if (event != null) {
            return event;
        }
        Vec3d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vec3d pos = control.rotateMouseVec(mouse);
            if (!control.isInteractable() || !control.isMouseOver((int)pos.field_72450_a, (int)pos.field_72448_b) || (event = control.getToolTipEvent()) == null) continue;
            return event;
        }
        return null;
    }
}

