/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.container;

import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.packet.gui.ContainerControlUpdatePacket;
import com.creativemd.creativecore.common.packet.gui.GuiLayerPacket;
import com.creativemd.creativecore.common.packet.gui.GuiNBTPacket;
import com.creativemd.creativecore.common.packet.gui.GuiUpdatePacket;
import com.creativemd.creativecore.event.CreativeCoreEventBus;
import com.creativemd.creativecore.gui.ContainerControl;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.ContainerParent;
import com.creativemd.creativecore.gui.event.ControlEvent;
import com.creativemd.creativecore.gui.mc.ContainerSub;
import com.creativemd.creativecore.gui.premade.SubContainerEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SubContainer
extends ContainerParent {
    public EntityPlayer player;
    public ContainerSub container;
    private CreativeCoreEventBus eventBus;

    public SubContainer(EntityPlayer player) {
        this("container", player);
    }

    public SubContainer(String name, EntityPlayer player) {
        super(name);
        this.player = player;
        this.eventBus = new CreativeCoreEventBus(player.func_130014_f_().field_72995_K);
        this.addListener(this);
    }

    public boolean isTopLayer() {
        return this.container.isTopLayer(this);
    }

    public int getLayerID() {
        return this.container.layers.indexOf(this);
    }

    public SubContainer createLayerFromPacket(World world, EntityPlayer player, NBTTagCompound nbt) {
        if (nbt.func_74767_n("dialog")) {
            return new SubContainerEmpty(player);
        }
        return null;
    }

    public void closeLayer(NBTTagCompound nbt) {
        this.closeLayer(nbt, false);
    }

    public void closeLayer(NBTTagCompound nbt, boolean isPacket) {
        if (!isPacket) {
            PacketHandler.sendPacketToServer(new GuiLayerPacket(nbt, this.getLayerID(), true));
        }
        this.onClosed();
        this.onLayerClosed(nbt, this);
        this.container.layers.remove(this);
    }

    public void onLayerClosed(NBTTagCompound nbt, SubContainer container) {
    }

    public void openNewLayer(NBTTagCompound nbt) {
        this.openNewLayer(nbt, false);
    }

    public void openNewLayer(NBTTagCompound nbt, boolean isPacket) {
        SubContainer Subcontainer = this.createLayerFromPacket(this.player.field_70170_p, this.player, nbt);
        Subcontainer.container = this.container;
        this.container.layers.add(Subcontainer);
        if (!isPacket) {
            PacketHandler.sendPacketToServer(new GuiLayerPacket(nbt, this.getLayerID(), false));
        }
    }

    @Override
    public boolean isInteractable() {
        return super.isInteractable() && this.isTopLayer();
    }

    @Override
    public boolean raiseEvent(ControlEvent event) {
        return !this.eventBus.raiseEvent(event);
    }

    @Override
    public void addListener(Object listener) {
        this.eventBus.RegisterEventListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        this.eventBus.removeEventListener(listener);
    }

    @Override
    public void onClosed() {
        for (int i = 0; i < this.controls.size(); ++i) {
            ((ContainerControl)this.controls.get(i)).onClosed();
        }
        this.eventBus.removeAllEventListeners();
    }

    @Override
    public void onOpened() {
        this.createControls();
        for (int i = 0; i < this.controls.size(); ++i) {
            ((ContainerControl)this.controls.get((int)i)).parent = this;
            ((ContainerControl)this.controls.get(i)).onOpened();
            ((ContainerControl)this.controls.get(i)).setID(i);
        }
        if (!this.player.func_130014_f_().field_72995_K) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeOpeningNBT(nbt);
            if (!nbt.func_82582_d()) {
                PacketHandler.sendPacketToPlayer(new GuiUpdatePacket(nbt, true, this.getLayerID()), (EntityPlayerMP)this.player);
            }
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    public abstract void createControls();

    @Override
    public void updateEqualContainers() {
    }

    public void sendNBTToGui(NBTTagCompound nbt) {
        if (this.player instanceof EntityPlayerMP) {
            PacketHandler.sendPacketToPlayer(new GuiNBTPacket(nbt), (EntityPlayerMP)this.player);
        }
    }

    public void sendNBTUpdate(NBTTagCompound nbt) {
        this.sendNBTUpdate(null, nbt);
    }

    @Override
    public void sendNBTUpdate(ContainerControl control, NBTTagCompound nbt) {
        String name;
        String string = name = control != null ? control.name : null;
        if (this.player.func_130014_f_().field_72995_K) {
            PacketHandler.sendPacketToServer(new ContainerControlUpdatePacket(this.getLayerID(), name, nbt));
        } else {
            PacketHandler.sendPacketToPlayer(new ContainerControlUpdatePacket(this.getLayerID(), name, nbt), (EntityPlayerMP)this.player);
        }
    }

    public void writeOpeningNBT(NBTTagCompound nbt) {
    }

    @Override
    public void writeToNBTUpdate(NBTTagCompound nbt) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiControl createGuiControl() {
        return null;
    }
}

