/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.controls.container.client;

import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.GuiRenderHelper;
import com.creativemd.creativecore.gui.client.style.ColoredDisplayStyle;
import com.creativemd.creativecore.gui.client.style.SidedColoredDisplayStyle;
import com.creativemd.creativecore.gui.client.style.Style;
import com.creativemd.creativecore.gui.controls.container.SlotControl;
import com.creativemd.creativecore.slots.SlotInput;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.util.Color;

public class GuiSlotControl
extends GuiControl {
    public static Style slotStyle = new Style("slot", new SidedColoredDisplayStyle(new Color(55, 55, 55), new Color(255, 255, 255), new Color(255, 255, 255), new Color(55, 55, 55)), new ColoredDisplayStyle(139, 139, 139), new ColoredDisplayStyle(197, 197, 197), new ColoredDisplayStyle(139, 139, 139), new ColoredDisplayStyle(0, 0, 0, 100));
    public SlotControl slot;
    public ItemStack dragged = null;
    public boolean isRightClick = false;
    public GuiSlotControl startSlot = null;
    public int[] stackSize = null;
    public int index = -1;

    public GuiSlotControl(int x, int y, SlotControl slot) {
        super(slot.slot.field_75224_c.func_70005_c_() + slot.slot.field_75222_d, x, y, 14, 14);
        this.slot = slot;
        this.width -= this.marginWidth;
        this.height -= this.marginWidth;
        this.marginWidth = 0;
    }

    @Override
    public Style getDefaultStyle() {
        return slotStyle;
    }

    protected ItemStack getStackToRender() {
        return this.slot.slot.func_75211_c();
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        if (this.isDragged()) {
            style.getMouseOverBackground(this).renderStyle(helper, width, height);
        }
        ItemStack stack = this.getStackToRender();
        ItemStack newStack = null;
        if (this.isDragged() && this.stackSize.length > 1) {
            this.updateHandStack();
            newStack = this.getItemStackByIndex(this.index);
        } else if (this.startSlot != null) {
            this.updateStackSize();
            newStack = this.startSlot.getItemStackByIndex(this.index);
        }
        if (newStack != null) {
            if (stack != null) {
                newStack.field_77994_a += stack.field_77994_a;
            }
            stack = newStack;
        }
        if (this.slot.slot instanceof SlotInput) {
            ItemStack backgroundStack = null;
            if (((SlotInput)this.slot.slot).input != null) {
                backgroundStack = ((SlotInput)this.slot.slot).input.getItemStack(1);
            }
            if (backgroundStack != null) {
                try {
                    helper.drawItemStackAndOverlay(backgroundStack, 0, 0, 16, 16);
                }
                catch (Exception e) {
                    helper.font.func_78276_b("X", 0, 0, ColorUtils.WHITE);
                }
            }
        }
        if (stack != null) {
            try {
                helper.drawItemStackAndOverlay(stack, 0, 0, 16, 16);
            }
            catch (Exception e) {
                helper.font.func_78276_b("X", 0, 0, ColorUtils.WHITE);
            }
        }
    }

    @Override
    public ArrayList<String> getTooltip() {
        ArrayList<String> tips = new ArrayList<String>();
        if (this.slot.slot.func_75216_d() && this.getPlayer().field_71071_by.func_70445_o() == null) {
            List list = null;
            try {
                list = this.slot.slot.func_75211_c().func_82840_a((EntityPlayer)GuiSlotControl.mc.field_71439_g, GuiSlotControl.mc.field_71474_y.field_82882_x);
                for (int k = 0; k < list.size(); ++k) {
                    if (k == 0) {
                        list.set(k, this.slot.slot.func_75211_c().func_77953_t().field_77937_e + (String)list.get(k));
                    } else {
                        list.set(k, ChatFormatting.GRAY + (String)list.get(k));
                    }
                    tips.add((String)list.get(k));
                }
            }
            catch (Exception e) {
                ItemStack stack = this.slot.slot.func_75211_c();
                try {
                    tips.add(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString());
                    tips.add("Damage: " + stack.func_77952_i());
                    tips.add("NBT: " + (stack.func_77942_o() ? "null" : stack.func_77978_p().toString()));
                }
                catch (Exception e2) {
                    tips.add("<ERRORED>");
                }
            }
        }
        return tips;
    }

    @Override
    public boolean onKeyPressed(char character, int key) {
        if (key == GuiSlotControl.mc.field_71474_y.field_74316_C.func_151463_i() && this.isMouseOver()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("ctrl", GuiScreen.func_146271_m());
            nbt.func_74768_a("type", 2);
            this.slot.sendPacket(nbt);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        this.sendClickedPacket(3, scrolled);
        return true;
    }

    public void sendClickedPacket(int button, int scrolled) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("button", button);
        boolean shift = GuiScreen.func_146272_n();
        nbt.func_74757_a("shift", shift);
        nbt.func_74768_a("scrolled", scrolled);
        nbt.func_74768_a("type", 1);
        this.slot.sendPacket(nbt);
        this.slot.onSlotClicked(button, shift, scrolled);
    }

    public boolean isDragged() {
        return this.dragged != null;
    }

    @Override
    public boolean mousePressed(int posX, int posY, int button) {
        ItemStack stack = this.getPlayer().field_71071_by.func_70445_o();
        if (stack != null && button < 2) {
            this.dragged = stack.func_77946_l();
            this.isRightClick = button == 1;
            boolean canStack = Container.func_94527_a((Slot)this.slot.slot, (ItemStack)this.dragged, (boolean)true);
            int stackSize = Math.min(this.slot.slot.func_75219_a(), this.dragged.func_77976_d());
            if (this.slot.slot.func_75216_d()) {
                stackSize -= this.slot.slot.func_75211_c().field_77994_a;
            }
            if (!this.slot.slot.func_75214_a(this.dragged)) {
                stackSize = 0;
            }
            if (stackSize > 0 && canStack) {
                this.stackSize = new int[1];
                this.stackSize[0] = stackSize;
                this.index = 0;
                return true;
            }
            this.dragged = null;
        }
        this.sendClickedPacket(button, 0);
        return true;
    }

    @Override
    public void mouseMove(int posX, int posY, int button) {
        if (this.startSlot == null && !this.isDragged() && this.isMouseOver()) {
            for (int i = 0; i < this.getParent().controls.size(); ++i) {
                if (!(this.getParent().controls.get(i) instanceof GuiSlotControl) || !((GuiSlotControl)this.getParent().controls.get(i)).isDragged()) continue;
                this.startSlot = (GuiSlotControl)this.getParent().controls.get(i);
                boolean canStack = Container.func_94527_a((Slot)this.slot.slot, (ItemStack)this.startSlot.dragged, (boolean)true);
                int stackSize = Math.min(this.slot.slot.func_75219_a(), this.startSlot.dragged.func_77976_d());
                if (this.slot.slot.func_75216_d()) {
                    stackSize -= this.slot.slot.func_75211_c().field_77994_a;
                }
                if (!this.slot.slot.func_75214_a(this.dragged)) {
                    stackSize = 0;
                }
                if (stackSize > 0 && canStack) {
                    int[] newStackSize = new int[this.startSlot.stackSize.length + 1];
                    for (int j = 0; j < this.startSlot.stackSize.length; ++j) {
                        newStackSize[j] = this.startSlot.stackSize[j];
                    }
                    newStackSize[this.startSlot.stackSize.length] = stackSize;
                    this.index = this.startSlot.stackSize.length;
                    this.startSlot.stackSize = newStackSize;
                    continue;
                }
                this.startSlot = null;
            }
        }
    }

    @Override
    public void mouseReleased(int posX, int posY, int button) {
        if (this.isDragged() && this.stackSize.length > 1) {
            NBTTagCompound nbt = new NBTTagCompound();
            int[] slotArray = new int[this.stackSize.length];
            slotArray[this.index] = this.slot.getID();
            for (int i = 0; i < this.getParent().controls.size(); ++i) {
                if (!(this.getParent().controls.get(i) instanceof GuiSlotControl) || ((GuiSlotControl)this.getParent().controls.get((int)i)).startSlot == null) continue;
                slotArray[((GuiSlotControl)this.getParent().controls.get((int)i)).index] = ((GuiSlotControl)this.getParent().controls.get((int)i)).slot.getID();
                ((GuiSlotControl)this.getParent().controls.get((int)i)).startSlot = null;
                ((GuiSlotControl)this.getParent().controls.get((int)i)).index = -1;
            }
            nbt.func_74783_a("slots", slotArray);
            nbt.func_74757_a("right", this.isRightClick);
            this.dragged.func_77955_b(nbt);
            nbt.func_74768_a("type", 3);
            this.slot.sendPacket(nbt);
            this.slot.splitStack(slotArray, this.dragged, this.isRightClick);
        } else if (this.isDragged()) {
            this.sendClickedPacket(this.isRightClick ? 1 : 0, 0);
        }
        this.dragged = null;
        this.stackSize = null;
    }

    public void updateStackSize() {
        if (this.startSlot != null) {
            int stackSize = Math.min(this.slot.slot.func_75219_a(), this.startSlot.dragged.func_77976_d());
            if (this.slot.slot.func_75216_d()) {
                stackSize -= this.slot.slot.func_75211_c().field_77994_a;
            }
            this.startSlot.stackSize[this.index] = stackSize;
        }
    }

    public ItemStack getItemStackByIndex(int index) {
        if (index >= this.dragged.field_77994_a) {
            return null;
        }
        ItemStack result = this.dragged.func_77946_l();
        if (this.isRightClick) {
            result.field_77994_a = 1;
        } else {
            int used = 0;
            int StackPerSlot = MathHelper.func_76141_d((float)((float)result.field_77994_a / (float)this.stackSize.length));
            for (int i = 0; i < index; ++i) {
                used += Math.min(StackPerSlot, this.stackSize[i]);
            }
            if (used < result.field_77994_a) {
                result.field_77994_a = Math.min(StackPerSlot, this.stackSize[index]);
            }
        }
        return result;
    }

    public void updateHandStack() {
        int used = 0;
        int StackPerSlot = MathHelper.func_76141_d((float)((float)this.dragged.field_77994_a / (float)this.stackSize.length));
        if (this.isRightClick) {
            StackPerSlot = 1;
        }
        for (int i = 0; i < this.stackSize.length; ++i) {
            used += Math.min(StackPerSlot, this.stackSize[i]);
        }
        int left = this.dragged.field_77994_a - used;
        ItemStack hand = this.getPlayer().field_71071_by.func_70445_o().func_77946_l();
        hand.field_77994_a = left;
        this.getPlayer().field_71071_by.func_70437_b(hand);
    }
}

