/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.controls.gui;

import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.GuiRenderHelper;
import com.creativemd.creativecore.gui.client.style.Style;
import com.creativemd.creativecore.gui.event.gui.GuiControlChangedEvent;
import net.minecraft.init.SoundEvents;

public class GuiAnalogeSlider
extends GuiControl {
    public float maxValue;
    public float minValue;
    public float value;
    public boolean grabbedSlider;
    public int sliderWidth = 4;

    public GuiAnalogeSlider(String name, int x, int y, int width, int height, float value, float minValue, float maxValue) {
        super(name, x, y, width, height);
        this.marginWidth = 0;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.setValue(value);
    }

    public String getTextByValue() {
        return (float)Math.round(this.value * 100.0f) / 100.0f + "";
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        float percent = this.getPercentage();
        int posX = (int)((float)(this.width - (this.borderWidth * 2 + this.sliderWidth)) * percent);
        style.getFace(this).renderStyle(posX, 0, helper, 4, height);
        String text = this.getTextByValue();
        helper.drawStringWithShadow(text, width, height, ColorUtils.WHITE);
    }

    public float getPercentage() {
        return (this.value - this.minValue) / (this.maxValue - this.minValue);
    }

    @Override
    public boolean mousePressed(int x, int y, int button) {
        if (button == 0) {
            GuiAnalogeSlider.playSound(SoundEvents.field_187909_gi);
            this.grabbedSlider = true;
            return true;
        }
        return false;
    }

    public void setValue(float value) {
        this.value = Math.max(this.minValue, value);
        this.value = Math.min(this.maxValue, this.value);
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    @Override
    public void mouseMove(int posX, int posY, int button) {
        if (this.grabbedSlider) {
            int width = this.width - this.getContentOffset() * 2 - this.sliderWidth;
            if (posX < this.posX + this.getContentOffset()) {
                this.value = this.minValue;
            } else if (posX > this.posX + this.getContentOffset() + width + this.sliderWidth / 2) {
                this.value = this.maxValue;
            } else {
                int mouseOffsetX = posX - this.posX - this.getContentOffset() - this.sliderWidth / 2;
                this.value = this.minValue + (this.maxValue - this.minValue) * ((float)mouseOffsetX / (float)width);
            }
            this.setValue(this.value);
        }
    }

    @Override
    public void mouseReleased(int posX, int posY, int button) {
        if (this.grabbedSlider) {
            this.grabbedSlider = false;
        }
    }
}

