/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.controls.gui.custom;

import com.creativemd.creativecore.gui.controls.container.SlotControlNoSync;
import com.creativemd.creativecore.gui.controls.container.client.GuiSlotControl;
import com.creativemd.creativecore.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.gui.controls.gui.GuiComboBoxExtension;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.gui.controls.gui.custom.GuiInvSelector;
import com.creativemd.creativecore.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.slots.SlotPreview;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiItemStackSelector
extends GuiComboBoxExtension {
    public ArrayList<ItemStack> stacks;
    public ArrayList<ItemStack> inv;
    public String search;
    public boolean onlyBlocks;

    public GuiItemStackSelector(String name, EntityPlayer player, int x, int y, int width, int height, GuiComboBox comboBox, boolean onlyBlocks, String search) {
        super(name, comboBox, x, y, width, height, new ArrayList<String>());
        this.search = search;
        this.onlyBlocks = onlyBlocks;
        this.stacks = new ArrayList();
        this.inv = new ArrayList();
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null) continue;
            this.inv.add(player.field_71071_by.field_70462_a[i]);
        }
        for (Item item : Item.field_150901_e) {
            if (item == null || item.func_77640_w() == null) continue;
            item.func_150895_a(item, (CreativeTabs)null, this.stacks);
        }
        this.reloadControls();
    }

    public static String getItemName(ItemStack stack) {
        String itemName = "";
        try {
            itemName = stack.func_82833_r();
        }
        catch (Exception e) {
            itemName = Block.func_149634_a((Item)stack.func_77973_b()) != null ? ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Block.func_149634_a((Item)stack.func_77973_b()))).toString() : ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
        }
        return itemName;
    }

    public static boolean shouldShowItem(boolean onlyBlocks, String search, ItemStack stack) {
        if (onlyBlocks && Block.func_149634_a((Item)stack.func_77973_b()) == null) {
            return false;
        }
        if (search.equals("")) {
            return true;
        }
        return GuiItemStackSelector.getItemName(stack).toLowerCase().contains(search);
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.addListener(this);
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.removeListener(this);
    }

    @Override
    public void reloadControls() {
        if (this.stacks != null) {
            int row;
            InventoryBasic basic;
            int i;
            this.controls.clear();
            int height = 0;
            GuiLabel label = new GuiLabel("Inventory", 3, height);
            label.width = this.width - 20;
            label.height = 14;
            this.controls.add(label);
            height += label.height;
            int SlotsPerRow = (this.width - 20) / 18;
            int count = 0;
            for (i = 0; i < this.inv.size(); ++i) {
                if (!GuiItemStackSelector.shouldShowItem(this.onlyBlocks, this.search, this.inv.get(i))) continue;
                basic = new InventoryBasic("", false, 1);
                basic.func_70299_a(0, this.inv.get(i));
                row = count / SlotsPerRow;
                this.addControl(new SlotControlNoSync(new SlotPreview((IInventory)basic, 0, (count - row * SlotsPerRow) * 18, height + row * 18)).getGuiControl());
                ++count;
            }
            height = (int)((double)height + Math.floor(count / SlotsPerRow + 1) * 18.0);
            label = new GuiLabel("Items", 3, height);
            label.width = this.width - 20;
            label.height = 14;
            this.addControl(label);
            height += label.height;
            count = 0;
            for (i = 0; i < this.stacks.size(); ++i) {
                if (!GuiItemStackSelector.shouldShowItem(this.onlyBlocks, this.search, this.stacks.get(i))) continue;
                basic = new InventoryBasic("", false, 1);
                basic.func_70299_a(0, this.stacks.get(i));
                row = count / SlotsPerRow;
                this.addControl(new SlotControlNoSync(new SlotPreview((IInventory)basic, 0, (count - row * SlotsPerRow) * 18, height + row * 18)).getGuiControl());
                ++count;
            }
        }
    }

    @CustomEventSubscribe
    public void onLabelClicked(GuiControlClickEvent event) {
        if (event.source instanceof GuiSlotControl && event.source.parent == this) {
            ((GuiInvSelector)this.comboBox).addAndSelectStack(((GuiSlotControl)event.source).slot.slot.func_75211_c().func_77946_l());
            this.comboBox.closeBox();
        }
    }

    @Override
    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        this.scrolled -= scrolled * 30;
        this.onScrolled();
        return true;
    }
}

