/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons;

import net.blay09.mods.eiramoticons.CommandEmoticons;
import net.blay09.mods.eiramoticons.CommonProxy;
import net.blay09.mods.eiramoticons.EiraMoticons;
import net.blay09.mods.eiramoticons.EmoticonConfig;
import net.blay09.mods.eiramoticons.InternalMethods;
import net.blay09.mods.eiramoticons.addon.FileAddon;
import net.blay09.mods.eiramoticons.addon.TwitchEmotesAPI;
import net.blay09.mods.eiramoticons.addon.pack.BTTVChannelPack;
import net.blay09.mods.eiramoticons.addon.pack.BTTVPack;
import net.blay09.mods.eiramoticons.addon.pack.FFZChannelPack;
import net.blay09.mods.eiramoticons.addon.pack.FFZPack;
import net.blay09.mods.eiramoticons.addon.pack.IncludedPack;
import net.blay09.mods.eiramoticons.addon.pack.TwitchGlobalPack;
import net.blay09.mods.eiramoticons.addon.pack.TwitchPrimePack;
import net.blay09.mods.eiramoticons.addon.pack.TwitchSmileyPack;
import net.blay09.mods.eiramoticons.addon.pack.TwitchSubscriberPack;
import net.blay09.mods.eiramoticons.api.EiraMoticonsAPI;
import net.blay09.mods.eiramoticons.api.EmoteLoaderException;
import net.blay09.mods.eiramoticons.api.IEmoticon;
import net.blay09.mods.eiramoticons.api.ReloadEmoticons;
import net.blay09.mods.eiramoticons.emoticon.Emoticon;
import net.blay09.mods.eiramoticons.emoticon.EmoticonHandler;
import net.blay09.mods.eiramoticons.emoticon.EmoticonRegistry;
import net.blay09.mods.eiramoticons.render.EmoticonRenderer;
import net.blay09.mods.eiramoticons.render.FontRendererExt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class ClientProxy
extends CommonProxy {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FONT_TEXTURE = "textures/font/ascii.png";
    public static int MAX_TEXTURE_SIZE;
    public static EmoticonRenderer renderer;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        EiraMoticonsAPI.setupAPI(new InternalMethods());
        EmoticonConfig.loadFromFile(event.getSuggestedConfigurationFile());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (EiraMoticons.hasSuperiorModInstalled) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRendererExt fontRenderer = new FontRendererExt(mc.field_71474_y, new ResourceLocation(FONT_TEXTURE), mc.field_71446_o, false);
        fontRenderer.func_78264_a(mc.func_152349_b());
        fontRenderer.func_78275_b(mc.func_135016_M().func_135044_b());
        ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)fontRenderer);
        mc.field_71466_p = fontRenderer;
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandEmoticons());
        renderer = new EmoticonRenderer(mc);
        fontRenderer.setEmoticonBuffer(renderer.getBuffer());
        MinecraftForge.EVENT_BUS.register((Object)renderer);
        MinecraftForge.EVENT_BUS.register((Object)this);
        TwitchEmotesAPI.initialize(mc.field_71412_D);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)new ReloadEmoticons());
        MAX_TEXTURE_SIZE = GL11.glGetInteger((int)3379);
    }

    @SubscribeEvent
    public void clientChatReceived(ClientChatReceivedEvent event) {
        if (EmoticonConfig.enableMCEmotes) {
            event.setMessage(EmoticonHandler.adjustChatComponent(event.getMessage()));
        }
    }

    @SubscribeEvent
    public void reloadEmoticons(ReloadEmoticons event) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Emoticon kappaHD;
                EmoticonRegistry.isLoading = true;
                if (EmoticonConfig.twitchSmileys) {
                    try {
                        new TwitchSmileyPack(EmoticonConfig.twitchSmileySet);
                    }
                    catch (EmoteLoaderException e) {
                        LOGGER.error("Failed to load Twitch smiley emotes: {}", (Throwable)e);
                    }
                }
                if (EmoticonConfig.twitchGlobalEmotes) {
                    try {
                        new TwitchGlobalPack();
                    }
                    catch (EmoteLoaderException e) {
                        LOGGER.error("Failed to load Twitch global emotes: {}", (Throwable)e);
                    }
                }
                if (EmoticonConfig.twitchPrimeEmotes) {
                    try {
                        new TwitchPrimePack();
                    }
                    catch (EmoteLoaderException e) {
                        LOGGER.error("Failed to load Twitch prime emotes: {}", (Throwable)e);
                    }
                }
                if (EmoticonConfig.twitchSubscriberEmotes) {
                    try {
                        new TwitchSubscriberPack(EmoticonConfig.twitchSubscriberRegex);
                    }
                    catch (EmoteLoaderException e) {
                        LOGGER.error("Failed to load Twitch subscriber emotes: {}", (Throwable)e);
                    }
                }
                if (EmoticonConfig.bttvEmotes) {
                    try {
                        new BTTVPack();
                    }
                    catch (EmoteLoaderException e) {
                        LOGGER.error("Failed to load BTTV emotes: {}", (Throwable)e);
                    }
                }
                if (EmoticonConfig.bttvChannelEmotes) {
                    try {
                        BTTVChannelPack.createGroup();
                        for (String channel : EmoticonConfig.bttvEmoteChannels) {
                            new BTTVChannelPack(channel);
                        }
                    }
                    catch (EmoteLoaderException e) {
                        LOGGER.error("Failed to load BTTV channel emotes: {}", (Throwable)e);
                    }
                }
                if (EmoticonConfig.ffzEmotes) {
                    try {
                        new FFZPack();
                    }
                    catch (EmoteLoaderException e) {
                        LOGGER.error("Failed to load FrankerFaceZ emotes: {}", (Throwable)e);
                    }
                }
                if (EmoticonConfig.ffzChannelEmotes) {
                    try {
                        FFZChannelPack.createGroup();
                        for (String channel : EmoticonConfig.ffzEmoteChannels) {
                            new FFZChannelPack(channel);
                        }
                    }
                    catch (EmoteLoaderException e) {
                        LOGGER.error("Failed to load FrankerFaceZ channel emotes: {}", (Throwable)e);
                    }
                }
                if (EmoticonConfig.defaultPack) {
                    try {
                        new IncludedPack("default", new String[]{"eiraRage", "eiraLewd", "eiraScared", "eiraCri", "eiraMeow", "eiraYawn", "eiraFufu", "eiraPraise", "eiraArr", "eiraCute"});
                    }
                    catch (EmoteLoaderException e) {
                        LOGGER.error("Failed to load default emotes: {}", new Object[]{e.getMessage()});
                    }
                }
                try {
                    new FileAddon();
                }
                catch (EmoteLoaderException e) {
                    LOGGER.error("Failed to load file emotes: {}", new Object[]{e.getMessage()});
                }
                if (EmoticonConfig.betterKappas && EmoticonConfig.twitchPrimeEmotes && (kappaHD = EmoticonRegistry.fromName("KappaHD")) != null) {
                    IEmoticon kappa = EmoticonRegistry.registerEmoticon("Kappa", kappaHD.getLoader());
                    kappa.setLoadData(kappaHD.getLoadData());
                    kappa.setTooltip(I18n.func_135052_a((String)"eiramoticons:group.betterkappas", (Object[])new Object[0]));
                }
                EmoticonRegistry.isLoading = false;
            }
        }, "Emote Loader").start();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("eiramoticons")) {
            EmoticonConfig.lightReload();
            EmoticonRegistry.reloadEmoticons();
        }
    }
}

