/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.addon;

import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import net.blay09.mods.eiramoticons.api.EiraMoticonsAPI;
import net.blay09.mods.eiramoticons.api.IEmoticon;
import net.blay09.mods.eiramoticons.api.IEmoticonLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class FileAddon
implements IEmoticonLoader {
    public FileAddon() {
        File emoticonDir = new File(Minecraft.func_71410_x().field_71412_D, "emoticons");
        if (!emoticonDir.exists() && !emoticonDir.mkdir()) {
            return;
        }
        File[] emoticons = emoticonDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".bmp") || name.endsWith(".gif");
            }
        });
        StringBuilder sb = new StringBuilder();
        if (emoticons != null) {
            for (File emoticonFile : emoticons) {
                String nameWithoutExt = Files.getNameWithoutExtension((String)emoticonFile.getName());
                IEmoticon emoticon = EiraMoticonsAPI.registerEmoticon(nameWithoutExt, this);
                sb.append(" ").append(nameWithoutExt);
                emoticon.setLoadData(emoticonFile);
                emoticon.setTooltip(I18n.func_135052_a((String)"eiramoticons:group.custom", (Object[])new Object[0]));
            }
        }
        if (sb.length() > 0) {
            EiraMoticonsAPI.registerEmoticonGroup("File Addon", EiraMoticonsAPI.replaceEmoticons((ITextComponent)new TextComponentTranslation("eiramoticons:command.list.file", new Object[]{sb.toString()})));
        }
    }

    @Override
    public void loadEmoticonImage(IEmoticon emoticon) {
        EiraMoticonsAPI.loadImage(emoticon, (File)emoticon.getLoadData());
    }
}

