/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.addon;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class TwitchEmotesAPI {
    public static final int TWITCH_BASE_SIZE = 28;
    public static final String URL_SMALL = "https://static-cdn.jtvnw.net/emoticons/v1/{image_id}/1.0";
    private static final int CACHE_LIFETIME_JSON = 86400000;
    private static final int CACHE_LIFETIME_IMAGE = 604800000;
    private static final int TIMEOUT_TIME = 10000;
    private static final String URL_GLOBAL = "https://twitchemotes.com/api_cache/v3/global.json";
    private static final String URL_SUBSCRIBER = "https://twitchemotes.com/api_cache/v3/subscriber.json";
    private static final String URL_PRIME = "https://api.twitch.tv/kraken/chat/emoticon_images?client_id=gdhi94otnk7c7746syjv7gkr6bizq4w&emotesets=19194";
    private static File cacheDir;
    private static File cachedEmotes;
    private static File cachedGlobal;
    private static File cachedSubscriber;
    private static File cachedPrime;

    public static void initialize(File mcDataDir) {
        cacheDir = new File(mcDataDir, "emoticons/cache");
        cachedEmotes = new File(cacheDir, "images/");
        cachedGlobal = new File(cacheDir, "global.json");
        cachedSubscriber = new File(cacheDir, "subscriber.json");
        cachedPrime = new File(cacheDir, "prime.json");
    }

    private static boolean shouldUseCacheFileJson(File file) {
        return file.exists() && System.currentTimeMillis() - file.lastModified() <= 86400000L;
    }

    private static boolean shouldUseCacheFileImage(File file) {
        return file.exists() && System.currentTimeMillis() - file.lastModified() <= 604800000L;
    }

    public static Reader newGlobalEmotesReader(boolean forceRemote) throws IOException {
        if (forceRemote || !TwitchEmotesAPI.shouldUseCacheFileJson(cachedGlobal)) {
            FileUtils.copyURLToFile((URL)new URL(URL_GLOBAL), (File)cachedGlobal, (int)10000, (int)10000);
        }
        return new FileReader(cachedGlobal);
    }

    public static Reader newSubscriberEmotesReader(boolean forceRemote) throws IOException {
        if (forceRemote || !TwitchEmotesAPI.shouldUseCacheFileJson(cachedSubscriber)) {
            FileUtils.copyURLToFile((URL)new URL(URL_SUBSCRIBER), (File)cachedSubscriber, (int)10000, (int)10000);
        }
        return new FileReader(cachedSubscriber);
    }

    public static Reader newPrimeEmotesReader(boolean forceRemote) throws IOException {
        if (forceRemote || !TwitchEmotesAPI.shouldUseCacheFileJson(cachedPrime)) {
            FileUtils.copyURLToFile((URL)new URL(URL_PRIME), (File)cachedPrime, (int)10000, (int)10000);
        }
        return new FileReader(cachedPrime);
    }

    public static BufferedImage readTwitchEmoteImage(String template, int imageId, String cachePrefix) {
        block9: {
            BufferedImage image;
            File cachedImageFile = new File(cachedEmotes, cachePrefix + "-" + imageId + ".png");
            if (TwitchEmotesAPI.shouldUseCacheFileImage(cachedImageFile)) {
                try {
                    image = ImageIO.read(cachedImageFile);
                    if (image != null) {
                        return image;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                image = ImageIO.read(new URL(template.replace("{image_id}", String.valueOf(imageId))));
                if (image == null) break block9;
                try {
                    if (cachedImageFile.mkdirs()) {
                        ImageIO.write((RenderedImage)image, "PNG", cachedImageFile);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return image;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void clearCache() {
        try {
            FileUtils.deleteDirectory((File)cacheDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

