/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.addon.pack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.blay09.mods.eiramoticons.addon.pack.AbstractEmotePack;
import net.blay09.mods.eiramoticons.api.EiraMoticonsAPI;
import net.blay09.mods.eiramoticons.api.EmoteLoaderException;
import net.blay09.mods.eiramoticons.api.IEmoticon;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class BTTVPack
extends AbstractEmotePack {
    private String urlTemplate;

    public BTTVPack() {
        try {
            URL apiURL = new URL("https://api.betterttv.net/2/emotes");
            InputStreamReader reader = new InputStreamReader(apiURL.openStream());
            Gson gson = new Gson();
            JsonObject root = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (root == null || !root.has("status") && root.get("status").getAsInt() != 200) {
                throw new EmoteLoaderException("Failed to grab BTTV emotes (unexpected status)");
            }
            this.urlTemplate = this.getJsonString(root, "urlTemplate");
            JsonArray emotes = root.getAsJsonArray("emotes");
            for (int i = 0; i < emotes.size(); ++i) {
                JsonObject entry = emotes.get(i).getAsJsonObject();
                String code = this.getJsonString(entry, "code");
                IEmoticon emoticon = EiraMoticonsAPI.registerEmoticon(code, this);
                emoticon.setLoadData(new String[]{this.getJsonString(entry, "id"), this.getJsonString(entry, "imageType")});
                emoticon.setTooltip(I18n.func_135052_a((String)"eiramoticons:group.twitch.bttv", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            throw new EmoteLoaderException("Unhandled exception", e);
        }
        TextComponentTranslation linkComponent = new TextComponentTranslation("eiramoticons:command.list.clickHere", new Object[0]);
        linkComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://nightdev.com/betterttv/faces.php"));
        linkComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("https://nightdev.com/betterttv/faces.php")));
        linkComponent.func_150256_b().func_150238_a(TextFormatting.GOLD);
        linkComponent.func_150256_b().func_150227_a(Boolean.valueOf(true));
        linkComponent.func_150256_b().func_150228_d(Boolean.valueOf(true));
        EiraMoticonsAPI.registerEmoticonGroup("Better TwitchTV", (ITextComponent)new TextComponentTranslation("eiramoticons:command.list.twitch.bttv", new Object[]{linkComponent}));
    }

    @Override
    public void loadEmoticonImage(IEmoticon emoticon) {
        try {
            String[] data = (String[])emoticon.getLoadData();
            EiraMoticonsAPI.loadImage(emoticon, new URI("https:" + this.urlTemplate.replace("{{id}}", data[0]).replace("{{image}}", "1x")));
        }
        catch (URISyntaxException e) {
            throw new EmoteLoaderException(e);
        }
    }
}

