/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.addon.pack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.blay09.mods.eiramoticons.api.EiraMoticonsAPI;
import net.blay09.mods.eiramoticons.api.EmoteLoaderException;
import net.blay09.mods.eiramoticons.api.IEmoticon;
import net.blay09.mods.eiramoticons.api.IEmoticonLoader;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class EiraNetPack
implements IEmoticonLoader {
    private String urlTemplate;

    public EiraNetPack() {
        try {
            URL apiURL = new URL("http://balyware.com/control-panel/api/emotes.php");
            InputStreamReader reader = new InputStreamReader(apiURL.openStream());
            Gson gson = new Gson();
            JsonObject root = null;
            try {
                root = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            if (root != null) {
                this.urlTemplate = "http:" + root.get("url_template").getAsString();
                JsonArray emotes = root.getAsJsonArray("emotes");
                for (int i = 0; i < emotes.size(); ++i) {
                    JsonObject emote = emotes.get(i).getAsJsonObject();
                    IEmoticon emoticon = EiraMoticonsAPI.registerEmoticon(emote.get("code").getAsString(), this);
                    emoticon.setLoadData(emote.get("id").getAsInt());
                    emoticon.setTooltip(I18n.func_135052_a((String)"eiramoticons:group.eiranet", (Object[])new Object[]{emote.get("owner").getAsString()}));
                }
            }
            reader.close();
        }
        catch (IOException e) {
            throw new EmoteLoaderException(e);
        }
        TextComponentTranslation linkComponent = new TextComponentTranslation("eiramoticons:command.list.clickHere", new Object[0]);
        linkComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://blay09.net/eiranet/"));
        linkComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("https://www.patreon.com/blay09")));
        linkComponent.func_150256_b().func_150238_a(TextFormatting.GOLD);
        linkComponent.func_150256_b().func_150227_a(Boolean.valueOf(true));
        linkComponent.func_150256_b().func_150228_d(Boolean.valueOf(true));
        EiraMoticonsAPI.registerEmoticonGroup("EiraNet User Emotes", (ITextComponent)new TextComponentTranslation("eiramoticons:command.list.eiranet", new Object[]{linkComponent}));
    }

    @Override
    public void loadEmoticonImage(IEmoticon emoticon) {
        if (this.urlTemplate != null) {
            try {
                EiraMoticonsAPI.loadImage(emoticon, new URI(this.urlTemplate.replace("{{id}}", String.valueOf(emoticon.getLoadData()))));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

