/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.addon.pack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.blay09.mods.eiramoticons.addon.pack.AbstractEmotePack;
import net.blay09.mods.eiramoticons.api.EiraMoticonsAPI;
import net.blay09.mods.eiramoticons.api.EmoteLoaderException;
import net.blay09.mods.eiramoticons.api.IEmoticon;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class FFZPack
extends AbstractEmotePack {
    public FFZPack() {
        try {
            URL apiURL = new URL("http://api.frankerfacez.com/v1/set/global");
            InputStreamReader reader = new InputStreamReader(apiURL.openStream());
            Gson gson = new Gson();
            JsonObject root = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (root == null) {
                throw new EmoteLoaderException("Failed to grab FrankerFaceZ emotes");
            }
            JsonArray defaultSets = root.getAsJsonArray("default_sets");
            JsonObject sets = root.getAsJsonObject("sets");
            for (int i = 0; i < defaultSets.size(); ++i) {
                int setId = defaultSets.get(i).getAsInt();
                JsonObject set = sets.getAsJsonObject(String.valueOf(setId));
                JsonArray emoticons = set.getAsJsonArray("emoticons");
                for (int j = 0; j < emoticons.size(); ++j) {
                    JsonObject emoticonObject = emoticons.get(j).getAsJsonObject();
                    String code = emoticonObject.get("name").getAsString();
                    IEmoticon emoticon = EiraMoticonsAPI.registerEmoticon(code, this);
                    emoticon.setLoadData(emoticonObject.getAsJsonObject("urls").get("1").getAsString());
                    emoticon.setTooltip(I18n.func_135052_a((String)"eiramoticons:group.twitch.ffz", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            throw new EmoteLoaderException("Unhandled exception", e);
        }
        TextComponentTranslation linkComponent = new TextComponentTranslation("eiramoticons:command.list.clickHere", new Object[0]);
        linkComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.frankerfacez.com/channel/__ffz_global"));
        linkComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("https://www.frankerfacez.com/channel/__ffz_global")));
        linkComponent.func_150256_b().func_150238_a(TextFormatting.GOLD);
        linkComponent.func_150256_b().func_150227_a(Boolean.valueOf(true));
        linkComponent.func_150256_b().func_150228_d(Boolean.valueOf(true));
        EiraMoticonsAPI.registerEmoticonGroup("FrankerFaceZ", (ITextComponent)new TextComponentTranslation("eiramoticons:command.list.twitch.ffz", new Object[]{linkComponent}));
    }

    @Override
    public void loadEmoticonImage(IEmoticon emoticon) {
        try {
            EiraMoticonsAPI.loadImage(emoticon, new URI("https:" + emoticon.getLoadData()));
        }
        catch (URISyntaxException e) {
            throw new EmoteLoaderException(e);
        }
    }
}

