/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.addon.pack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.Reader;
import net.blay09.mods.eiramoticons.addon.TwitchEmotesAPI;
import net.blay09.mods.eiramoticons.addon.pack.AbstractEmotePack;
import net.blay09.mods.eiramoticons.api.EiraMoticonsAPI;
import net.blay09.mods.eiramoticons.api.EmoteLoaderException;
import net.blay09.mods.eiramoticons.api.IEmoticon;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class TwitchPrimePack
extends AbstractEmotePack {
    public TwitchPrimePack() {
        try {
            JsonObject emoteList;
            Reader reader = TwitchEmotesAPI.newPrimeEmotesReader(false);
            Gson gson = new Gson();
            try {
                emoteList = (JsonObject)gson.fromJson(reader, JsonObject.class);
            }
            catch (Exception e) {
                reader = TwitchEmotesAPI.newPrimeEmotesReader(true);
                try {
                    emoteList = (JsonObject)gson.fromJson(reader, JsonObject.class);
                }
                catch (Exception e2) {
                    throw new EmoteLoaderException(e2);
                }
            }
            if (emoteList != null) {
                JsonObject emoticon_sets = this.getJsonObject(emoteList, "emoticon_sets");
                JsonArray emotes = this.getJsonArray(emoticon_sets, "19194");
                for (int i = 0; i < emotes.size(); ++i) {
                    JsonObject emote = emotes.get(i).getAsJsonObject();
                    String code = this.getJsonString(emote, "code");
                    IEmoticon emoticon = EiraMoticonsAPI.registerEmoticon(code, this);
                    emoticon.setLoadData(this.getJsonInt(emote, "id"));
                    emoticon.setTooltip(I18n.func_135052_a((String)"eiramoticons:group.twitch.prime", (Object[])new Object[0]));
                }
            }
            reader.close();
        }
        catch (Exception e) {
            throw new EmoteLoaderException("Unhandled exception", e);
        }
        TextComponentTranslation linkComponent = new TextComponentTranslation("eiramoticons:command.list.clickHere", new Object[0]);
        linkComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://twitchemotes.com/"));
        linkComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("https://twitchemotes.com/")));
        linkComponent.func_150256_b().func_150238_a(TextFormatting.GOLD);
        linkComponent.func_150256_b().func_150227_a(Boolean.valueOf(true));
        linkComponent.func_150256_b().func_150228_d(Boolean.valueOf(true));
        EiraMoticonsAPI.registerEmoticonGroup("Twitch Prime", (ITextComponent)new TextComponentTranslation("eiramoticons:command.list.twitch.prime", new Object[]{linkComponent}));
    }

    @Override
    public void loadEmoticonImage(IEmoticon emoticon) {
        BufferedImage image = TwitchEmotesAPI.readTwitchEmoteImage("https://static-cdn.jtvnw.net/emoticons/v1/{image_id}/1.0", (Integer)emoticon.getLoadData(), "prime");
        if (image != null) {
            emoticon.setImage(image);
            if (image.getWidth() <= 28 || image.getHeight() <= 28) {
                emoticon.setScale(0.5f, 0.5f);
            }
        }
    }
}

