/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.addon.pack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.eiramoticons.addon.TwitchEmotesAPI;
import net.blay09.mods.eiramoticons.addon.pack.AbstractEmotePack;
import net.blay09.mods.eiramoticons.api.EiraMoticonsAPI;
import net.blay09.mods.eiramoticons.api.EmoteLoaderException;
import net.blay09.mods.eiramoticons.api.IEmoticon;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class TwitchSubscriberPack
extends AbstractEmotePack {
    public TwitchSubscriberPack(String regexFilter) {
        try {
            JsonObject emoteList;
            Pattern pattern = Pattern.compile(regexFilter);
            Matcher matcher = pattern.matcher("");
            Reader reader = TwitchEmotesAPI.newSubscriberEmotesReader(false);
            Gson gson = new Gson();
            try {
                emoteList = (JsonObject)gson.fromJson(reader, JsonObject.class);
            }
            catch (Exception e) {
                reader = TwitchEmotesAPI.newSubscriberEmotesReader(true);
                try {
                    emoteList = (JsonObject)gson.fromJson(reader, JsonObject.class);
                }
                catch (Exception e2) {
                    throw new EmoteLoaderException(e2);
                }
            }
            if (emoteList != null) {
                for (Map.Entry channelEntry : emoteList.entrySet()) {
                    JsonObject channel = ((JsonElement)channelEntry.getValue()).getAsJsonObject();
                    String channelName = this.getJsonString(channel, "display_name");
                    JsonArray channelEmotes = this.getJsonArray(channel, "emotes");
                    for (int i = 0; i < channelEmotes.size(); ++i) {
                        JsonObject emote = channelEmotes.get(i).getAsJsonObject();
                        String code = this.getJsonString(emote, "code");
                        matcher.reset(code);
                        if (!matcher.matches()) continue;
                        IEmoticon emoticon = EiraMoticonsAPI.registerEmoticon(code, this);
                        emoticon.setLoadData(this.getJsonInt(emote, "id"));
                        emoticon.setTooltip(I18n.func_135052_a((String)"eiramoticons:group.twitch.subscriber", (Object[])new Object[]{channelName.toLowerCase()}));
                    }
                }
            }
            reader.close();
        }
        catch (Exception e) {
            throw new EmoteLoaderException("Unhandled exception", e);
        }
        TextComponentTranslation linkComponent = new TextComponentTranslation("eiramoticons:command.list.clickHere", new Object[0]);
        linkComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://twitchemotes.com/"));
        linkComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("https://twitchemotes.com/")));
        linkComponent.func_150256_b().func_150238_a(TextFormatting.GOLD);
        linkComponent.func_150256_b().func_150227_a(Boolean.valueOf(true));
        linkComponent.func_150256_b().func_150228_d(Boolean.valueOf(true));
        EiraMoticonsAPI.registerEmoticonGroup("Twitch Subscriber", (ITextComponent)new TextComponentTranslation("eiramoticons:command.list.twitch.subscriber", new Object[]{linkComponent}));
    }

    @Override
    public void loadEmoticonImage(IEmoticon emoticon) {
        BufferedImage image = TwitchEmotesAPI.readTwitchEmoteImage("https://static-cdn.jtvnw.net/emoticons/v1/{image_id}/1.0", (Integer)emoticon.getLoadData(), "global");
        if (image != null) {
            emoticon.setImage(image);
            if (image.getWidth() <= 28 || image.getHeight() <= 28) {
                emoticon.setScale(0.5f, 0.5f);
            }
        }
    }
}

