/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.emoticon;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import net.blay09.mods.eiramoticons.ClientProxy;
import net.blay09.mods.eiramoticons.api.IEmoticon;
import net.blay09.mods.eiramoticons.api.IEmoticonLoader;
import net.blay09.mods.eiramoticons.emoticon.AsyncEmoticonLoader;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;

public class Emoticon
implements IEmoticon {
    public final IEmoticonLoader loader;
    public final int id;
    public final String code;
    private Object identifier;
    private String[] tooltipLines;
    private boolean manualOnly;
    private boolean loadRequested;
    private int textureId = -1;
    private int width;
    private int height;
    private float scaleX;
    private float scaleY;
    private BufferedImage loadBuffer;
    private int[] frameTimes;
    private boolean cumulativeRendering;
    private int animationFrames;
    private int spriteSheetWidth;
    private int spriteSheetHeight;
    private int animationTime;
    private int currentFrameTime;
    private int currentFrame;
    private int currentFrameTexCoordX;
    private int currentFrameTexCoordY;
    private long lastRenderTime;

    public Emoticon(int id, String code, IEmoticonLoader loader) {
        this.id = id;
        this.code = code;
        this.loader = loader;
        this.tooltipLines = new String[]{I18n.func_135052_a((String)"eiramoticons:tooltip.name", (Object[])new Object[]{code})};
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getChatString() {
        return "\u00a7z" + this.id + "    ";
    }

    @Override
    public String getName() {
        return this.code;
    }

    @Override
    public Object getLoadData() {
        return this.identifier;
    }

    @Override
    public void setLoadData(Object loadData) {
        this.identifier = loadData;
    }

    @Override
    public IEmoticonLoader getLoader() {
        return this.loader;
    }

    @Override
    public boolean isManualOnly() {
        return this.manualOnly;
    }

    @Override
    public void setManualOnly(boolean manualOnly) {
        this.manualOnly = manualOnly;
    }

    @Override
    public void setTooltip(String emoticonGroup) {
        this.tooltipLines = new String[]{I18n.func_135052_a((String)"eiramoticons:tooltip.name", (Object[])new Object[]{this.code}), I18n.func_135052_a((String)"eiramoticons:tooltip.group", (Object[])new Object[]{emoticonGroup})};
    }

    @Override
    public void setCustomTooltip(String[] tooltipLines) {
        this.tooltipLines = tooltipLines;
    }

    private void calculateScale() {
        float factor;
        float renderWidth = this.width;
        float renderHeight = this.height;
        if (renderWidth > 16.0f) {
            factor = 16.0f / renderWidth;
            renderWidth *= factor;
            renderHeight *= factor;
        }
        if (renderHeight > 14.0f) {
            factor = 14.0f / renderHeight;
            renderWidth *= factor;
            renderHeight *= factor;
        }
        this.scaleX = renderWidth / (float)this.width;
        this.scaleY = renderHeight / (float)this.height;
    }

    @Override
    public void setImage(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.calculateScale();
        this.loadBuffer = image;
    }

    @Override
    public void setImages(BufferedImage[] images, int[] frameTime, int[] offsetX, int[] offsetY) {
        this.frameTimes = frameTime;
        this.width = images[0].getWidth();
        this.height = images[0].getHeight();
        this.animationFrames = images.length;
        this.calculateScale();
        this.spriteSheetWidth = this.width * images.length;
        this.spriteSheetHeight = this.height;
        if (this.spriteSheetWidth > ClientProxy.MAX_TEXTURE_SIZE) {
            int overflowX = ClientProxy.MAX_TEXTURE_SIZE % this.width;
            this.spriteSheetWidth = ClientProxy.MAX_TEXTURE_SIZE - overflowX;
            this.spriteSheetHeight = (int)((double)this.height * (Math.ceil(overflowX / ClientProxy.MAX_TEXTURE_SIZE) + 1.0));
            if (this.spriteSheetHeight > ClientProxy.MAX_TEXTURE_SIZE) {
                this.loadBuffer = images[0];
                return;
            }
        }
        int framesPerX = this.spriteSheetWidth / this.width;
        int framesPerY = this.spriteSheetHeight / this.height;
        this.loadBuffer = new BufferedImage(this.spriteSheetWidth, this.spriteSheetHeight, 2);
        DrawImageCallback callback = new DrawImageCallback();
        Graphics2D g = this.loadBuffer.createGraphics();
        for (int y = 0; y < framesPerY; ++y) {
            for (int x = 0; x < framesPerX; ++x) {
                int frameIdx = x + y * framesPerX;
                if (this.cumulativeRendering && frameIdx > 0) {
                    int prevFrameIdx = frameIdx - 1;
                    int prevFrameX = prevFrameIdx % framesPerX;
                    int prevFrameY = (int)Math.floor((float)prevFrameIdx / (float)framesPerX);
                    int dx = x * this.width - prevFrameX * this.width;
                    int dy = y * this.height - prevFrameY * this.height;
                    g.copyArea(prevFrameX * this.width, prevFrameY * this.height, this.width, this.height, dx, dy);
                }
                callback.prepare();
                if (g.drawImage((Image)images[frameIdx], x * this.width + offsetX[frameIdx], y * this.height + offsetY[frameIdx], callback)) continue;
                while (!callback.isReady()) {
                }
            }
        }
    }

    public int getTextureId() {
        if (this.loadBuffer != null) {
            this.textureId = TextureUtil.func_110987_a((int)TextureUtil.func_110996_a(), (BufferedImage)this.loadBuffer);
            this.loadBuffer = null;
        }
        return this.textureId;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void requestTexture() {
        if (!this.loadRequested) {
            this.loadRequested = true;
            AsyncEmoticonLoader.instance.loadAsync(this);
        }
    }

    public void disposeTexture() {
        if (this.textureId != -1) {
            TextureUtil.func_147942_a((int)this.textureId);
        }
    }

    public String[] getTooltip() {
        return this.tooltipLines;
    }

    @Override
    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    @Override
    public float getScaleX() {
        return this.scaleX;
    }

    @Override
    public float getScaleY() {
        return this.scaleY;
    }

    @Override
    public boolean isAnimated() {
        return this.frameTimes != null;
    }

    public void updateAnimation() {
        long now = System.currentTimeMillis();
        if (this.lastRenderTime == 0L) {
            this.lastRenderTime = now;
            this.currentFrameTime = this.frameTimes[0];
        }
        this.animationTime = (int)((long)this.animationTime + (now - this.lastRenderTime));
        int lastFrame = this.currentFrame;
        while (this.animationTime > this.currentFrameTime) {
            this.animationTime -= this.currentFrameTime;
            ++this.currentFrame;
            if (this.currentFrame >= this.animationFrames) {
                this.currentFrame = 0;
            }
            this.currentFrameTime = this.frameTimes[this.currentFrame];
        }
        if (this.currentFrame != lastFrame) {
            this.currentFrameTexCoordX = this.currentFrame * this.width;
            while (this.currentFrameTexCoordX > this.spriteSheetWidth) {
                this.currentFrameTexCoordX -= this.spriteSheetWidth;
                this.currentFrameTexCoordY += this.height;
            }
        }
        this.lastRenderTime = now;
    }

    public int getCurrentFrameTexCoordX() {
        return this.currentFrameTexCoordX;
    }

    public int getCurrentFrameTexCoordY() {
        return this.currentFrameTexCoordY;
    }

    public int getSheetWidth() {
        return this.spriteSheetWidth;
    }

    public int getSheetHeight() {
        return this.spriteSheetHeight;
    }

    @Override
    public void setCumulativeRendering(boolean cumulativeRendering) {
        this.cumulativeRendering = cumulativeRendering;
    }

    @Override
    public boolean isCumulativeRendering() {
        return this.cumulativeRendering;
    }

    private static class DrawImageCallback
    implements ImageObserver {
        private boolean isReady;

        private DrawImageCallback() {
        }

        public void prepare() {
            this.isReady = false;
        }

        @Override
        public boolean imageUpdate(Image img, int infoFlags, int x, int y, int width, int height) {
            if ((infoFlags & 0x20) == 32) {
                this.isReady = true;
            } else if ((infoFlags & 0x80) == 128) {
                this.isReady = true;
            }
            return false;
        }

        public boolean isReady() {
            return this.isReady;
        }
    }
}

