/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.emoticon;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.eiramoticons.emoticon.Emoticon;
import net.blay09.mods.eiramoticons.emoticon.EmoticonRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class EmoticonHandler {
    private static final Pattern EMOTICON_PATTERN = Pattern.compile("[A-Za-z0-9#:;<>_/\\|\\(\\)\\.\\\\\\]\\[]+");

    public static String replaceEmoticons(String text) {
        int currentIdx = 0;
        StringBuilder sb = new StringBuilder();
        Matcher matcher = EMOTICON_PATTERN.matcher(text);
        while (matcher.find()) {
            String word;
            Emoticon emoticon;
            if (matcher.start() > currentIdx) {
                sb.append(text.substring(currentIdx, matcher.start()));
            }
            if ((emoticon = EmoticonRegistry.fromName(word = matcher.group())) != null && !emoticon.isManualOnly()) {
                sb.append("\u00a7z").append(emoticon.id).append("    ");
            } else {
                sb.append(word);
            }
            currentIdx = matcher.end();
        }
        if (currentIdx < text.length()) {
            sb.append(text.substring(currentIdx));
        }
        return sb.toString();
    }

    public static ITextComponent adjustChatComponent(ITextComponent chatComponent) {
        if (chatComponent instanceof TextComponentString) {
            return EmoticonHandler.adjustTextComponent((TextComponentString)chatComponent);
        }
        if (chatComponent instanceof TextComponentTranslation) {
            return EmoticonHandler.adjustTranslationComponent((TextComponentTranslation)chatComponent);
        }
        return null;
    }

    public static ITextComponent adjustTextComponent(TextComponentString chatComponent) {
        TextComponentString copyComponent = new TextComponentString(EmoticonHandler.replaceEmoticons(chatComponent.func_150265_g()));
        copyComponent.func_150255_a(chatComponent.func_150256_b());
        for (Object object : chatComponent.func_150253_a()) {
            ITextComponent adjustedComponent = EmoticonHandler.adjustChatComponent((ITextComponent)object);
            if (adjustedComponent == null) continue;
            copyComponent.func_150257_a(adjustedComponent);
        }
        return copyComponent;
    }

    public static ITextComponent adjustTranslationComponent(TextComponentTranslation chatComponent) {
        Object[] formatArgs = chatComponent.func_150271_j();
        Object[] copyFormatArgs = new Object[formatArgs.length];
        for (int i = 0; i < formatArgs.length; ++i) {
            if (formatArgs[i] instanceof ITextComponent) {
                copyFormatArgs[i] = EmoticonHandler.adjustChatComponent((ITextComponent)formatArgs[i]);
                continue;
            }
            TextComponentString textComponent = new TextComponentString(formatArgs[i] == null ? "null" : EmoticonHandler.replaceEmoticons(formatArgs[i].toString()));
            textComponent.func_150256_b().func_150221_a(chatComponent.func_150256_b());
            copyFormatArgs[i] = textComponent;
        }
        TextComponentTranslation copyComponent = new TextComponentTranslation(chatComponent.func_150268_i(), copyFormatArgs);
        copyComponent.func_150255_a(chatComponent.func_150256_b());
        for (Object object : chatComponent.func_150253_a()) {
            ITextComponent adjustedComponent = EmoticonHandler.adjustChatComponent((ITextComponent)object);
            if (adjustedComponent == null) continue;
            copyComponent.func_150257_a(adjustedComponent);
        }
        return copyComponent;
    }
}

